package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "operatorName", 
    "sourceOperandName", 
    "targetOperand"})
@JsonInclude(Include.NON_NULL)
public class FilterClause implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("operatorName")
    protected String operatorName;

    @JsonProperty("sourceOperandName")
    protected String sourceOperandName;

    @JsonProperty("targetOperand")
    protected FilterOperand targetOperand;

    protected FilterClause() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.filterClause";
    }

    @Property(name="operatorName")
    @JsonIgnore
    public Optional<String> getOperatorName() {
        return Optional.ofNullable(operatorName);
    }

    public FilterClause withOperatorName(String operatorName) {
        FilterClause _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.filterClause");
        _x.operatorName = operatorName;
        return _x;
    }

    @Property(name="sourceOperandName")
    @JsonIgnore
    public Optional<String> getSourceOperandName() {
        return Optional.ofNullable(sourceOperandName);
    }

    public FilterClause withSourceOperandName(String sourceOperandName) {
        FilterClause _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.filterClause");
        _x.sourceOperandName = sourceOperandName;
        return _x;
    }

    @Property(name="targetOperand")
    @JsonIgnore
    public Optional<FilterOperand> getTargetOperand() {
        return Optional.ofNullable(targetOperand);
    }

    public FilterClause withTargetOperand(FilterOperand targetOperand) {
        FilterClause _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.filterClause");
        _x.targetOperand = targetOperand;
        return _x;
    }

    public FilterClause withUnmappedField(String name, Object value) {
        FilterClause _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String operatorName;
        private String sourceOperandName;
        private FilterOperand targetOperand;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder operatorName(String operatorName) {
            this.operatorName = operatorName;
            this.changedFields = changedFields.add("operatorName");
            return this;
        }

        public Builder sourceOperandName(String sourceOperandName) {
            this.sourceOperandName = sourceOperandName;
            this.changedFields = changedFields.add("sourceOperandName");
            return this;
        }

        public Builder targetOperand(FilterOperand targetOperand) {
            this.targetOperand = targetOperand;
            this.changedFields = changedFields.add("targetOperand");
            return this;
        }

        public FilterClause build() {
            FilterClause _x = new FilterClause();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.filterClause";
            _x.operatorName = operatorName;
            _x.sourceOperandName = sourceOperandName;
            _x.targetOperand = targetOperand;
            return _x;
        }
    }

    private FilterClause _copy() {
        FilterClause _x = new FilterClause();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.operatorName = operatorName;
        _x.sourceOperandName = sourceOperandName;
        _x.targetOperand = targetOperand;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FilterClause[");
        b.append("operatorName=");
        b.append(this.operatorName);
        b.append(", ");
        b.append("sourceOperandName=");
        b.append(this.sourceOperandName);
        b.append(", ");
        b.append("targetOperand=");
        b.append(this.targetOperand);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
