package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "categoryFilterGroups", 
    "groups", 
    "inputFilterGroups"})
@JsonInclude(Include.NON_NULL)
public class Filter implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("categoryFilterGroups")
    protected List<FilterGroup> categoryFilterGroups;

    @JsonProperty("categoryFilterGroups@nextLink")
    protected String categoryFilterGroupsNextLink;

    @JsonProperty("groups")
    protected List<FilterGroup> groups;

    @JsonProperty("groups@nextLink")
    protected String groupsNextLink;

    @JsonProperty("inputFilterGroups")
    protected List<FilterGroup> inputFilterGroups;

    @JsonProperty("inputFilterGroups@nextLink")
    protected String inputFilterGroupsNextLink;

    protected Filter() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.filter";
    }

    @Property(name="categoryFilterGroups")
    @JsonIgnore
    public CollectionPage<FilterGroup> getCategoryFilterGroups() {
        return new CollectionPage<FilterGroup>(contextPath, FilterGroup.class, this.categoryFilterGroups, Optional.ofNullable(categoryFilterGroupsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="categoryFilterGroups")
    @JsonIgnore
    public CollectionPage<FilterGroup> getCategoryFilterGroups(HttpRequestOptions options) {
        return new CollectionPage<FilterGroup>(contextPath, FilterGroup.class, this.categoryFilterGroups, Optional.ofNullable(categoryFilterGroupsNextLink), Collections.emptyList(), options);
    }

    @Property(name="groups")
    @JsonIgnore
    public CollectionPage<FilterGroup> getGroups() {
        return new CollectionPage<FilterGroup>(contextPath, FilterGroup.class, this.groups, Optional.ofNullable(groupsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="groups")
    @JsonIgnore
    public CollectionPage<FilterGroup> getGroups(HttpRequestOptions options) {
        return new CollectionPage<FilterGroup>(contextPath, FilterGroup.class, this.groups, Optional.ofNullable(groupsNextLink), Collections.emptyList(), options);
    }

    @Property(name="inputFilterGroups")
    @JsonIgnore
    public CollectionPage<FilterGroup> getInputFilterGroups() {
        return new CollectionPage<FilterGroup>(contextPath, FilterGroup.class, this.inputFilterGroups, Optional.ofNullable(inputFilterGroupsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="inputFilterGroups")
    @JsonIgnore
    public CollectionPage<FilterGroup> getInputFilterGroups(HttpRequestOptions options) {
        return new CollectionPage<FilterGroup>(contextPath, FilterGroup.class, this.inputFilterGroups, Optional.ofNullable(inputFilterGroupsNextLink), Collections.emptyList(), options);
    }

    public Filter withUnmappedField(String name, Object value) {
        Filter _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<FilterGroup> categoryFilterGroups;
        private String categoryFilterGroupsNextLink;
        private List<FilterGroup> groups;
        private String groupsNextLink;
        private List<FilterGroup> inputFilterGroups;
        private String inputFilterGroupsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder categoryFilterGroups(List<FilterGroup> categoryFilterGroups) {
            this.categoryFilterGroups = categoryFilterGroups;
            this.changedFields = changedFields.add("categoryFilterGroups");
            return this;
        }

        public Builder categoryFilterGroups(FilterGroup... categoryFilterGroups) {
            return categoryFilterGroups(Arrays.asList(categoryFilterGroups));
        }

        public Builder categoryFilterGroupsNextLink(String categoryFilterGroupsNextLink) {
            this.categoryFilterGroupsNextLink = categoryFilterGroupsNextLink;
            this.changedFields = changedFields.add("categoryFilterGroups");
            return this;
        }

        public Builder groups(List<FilterGroup> groups) {
            this.groups = groups;
            this.changedFields = changedFields.add("groups");
            return this;
        }

        public Builder groups(FilterGroup... groups) {
            return groups(Arrays.asList(groups));
        }

        public Builder groupsNextLink(String groupsNextLink) {
            this.groupsNextLink = groupsNextLink;
            this.changedFields = changedFields.add("groups");
            return this;
        }

        public Builder inputFilterGroups(List<FilterGroup> inputFilterGroups) {
            this.inputFilterGroups = inputFilterGroups;
            this.changedFields = changedFields.add("inputFilterGroups");
            return this;
        }

        public Builder inputFilterGroups(FilterGroup... inputFilterGroups) {
            return inputFilterGroups(Arrays.asList(inputFilterGroups));
        }

        public Builder inputFilterGroupsNextLink(String inputFilterGroupsNextLink) {
            this.inputFilterGroupsNextLink = inputFilterGroupsNextLink;
            this.changedFields = changedFields.add("inputFilterGroups");
            return this;
        }

        public Filter build() {
            Filter _x = new Filter();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.filter";
            _x.categoryFilterGroups = categoryFilterGroups;
            _x.categoryFilterGroupsNextLink = categoryFilterGroupsNextLink;
            _x.groups = groups;
            _x.groupsNextLink = groupsNextLink;
            _x.inputFilterGroups = inputFilterGroups;
            _x.inputFilterGroupsNextLink = inputFilterGroupsNextLink;
            return _x;
        }
    }

    private Filter _copy() {
        Filter _x = new Filter();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.categoryFilterGroups = categoryFilterGroups;
        _x.groups = groups;
        _x.inputFilterGroups = inputFilterGroups;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Filter[");
        b.append("categoryFilterGroups=");
        b.append(this.categoryFilterGroups);
        b.append(", ");
        b.append("groups=");
        b.append(this.groups);
        b.append(", ");
        b.append("inputFilterGroups=");
        b.append(this.inputFilterGroups);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
