package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "definition", 
    "properties"})
@JsonInclude(Include.NON_NULL)
public class ExpressionInputObject implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("definition")
    protected ObjectDefinition definition;

    @JsonProperty("properties")
    protected List<StringKeyObjectValuePair> properties;

    @JsonProperty("properties@nextLink")
    protected String propertiesNextLink;

    protected ExpressionInputObject() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.expressionInputObject";
    }

    @Property(name="definition")
    @JsonIgnore
    public Optional<ObjectDefinition> getDefinition() {
        return Optional.ofNullable(definition);
    }

    public ExpressionInputObject withDefinition(ObjectDefinition definition) {
        ExpressionInputObject _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.expressionInputObject");
        _x.definition = definition;
        return _x;
    }

    @Property(name="properties")
    @JsonIgnore
    public CollectionPage<StringKeyObjectValuePair> getProperties() {
        return new CollectionPage<StringKeyObjectValuePair>(contextPath, StringKeyObjectValuePair.class, this.properties, Optional.ofNullable(propertiesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="properties")
    @JsonIgnore
    public CollectionPage<StringKeyObjectValuePair> getProperties(HttpRequestOptions options) {
        return new CollectionPage<StringKeyObjectValuePair>(contextPath, StringKeyObjectValuePair.class, this.properties, Optional.ofNullable(propertiesNextLink), Collections.emptyList(), options);
    }

    public ExpressionInputObject withUnmappedField(String name, Object value) {
        ExpressionInputObject _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ObjectDefinition definition;
        private List<StringKeyObjectValuePair> properties;
        private String propertiesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder definition(ObjectDefinition definition) {
            this.definition = definition;
            this.changedFields = changedFields.add("definition");
            return this;
        }

        public Builder properties(List<StringKeyObjectValuePair> properties) {
            this.properties = properties;
            this.changedFields = changedFields.add("properties");
            return this;
        }

        public Builder properties(StringKeyObjectValuePair... properties) {
            return properties(Arrays.asList(properties));
        }

        public Builder propertiesNextLink(String propertiesNextLink) {
            this.propertiesNextLink = propertiesNextLink;
            this.changedFields = changedFields.add("properties");
            return this;
        }

        public ExpressionInputObject build() {
            ExpressionInputObject _x = new ExpressionInputObject();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.expressionInputObject";
            _x.definition = definition;
            _x.properties = properties;
            _x.propertiesNextLink = propertiesNextLink;
            return _x;
        }
    }

    private ExpressionInputObject _copy() {
        ExpressionInputObject _x = new ExpressionInputObject();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.definition = definition;
        _x.properties = properties;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExpressionInputObject[");
        b.append("definition=");
        b.append(this.definition);
        b.append(", ");
        b.append("properties=");
        b.append(this.properties);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
