package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Contains properties for Excluded Office365 Apps.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "access", 
    "bing", 
    "excel", 
    "groove", 
    "infoPath", 
    "lync", 
    "oneDrive", 
    "oneNote", 
    "outlook", 
    "powerPoint", 
    "publisher", 
    "sharePointDesigner", 
    "teams", 
    "visio", 
    "word"})
@JsonInclude(Include.NON_NULL)
public class ExcludedApps implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("access")
    protected Boolean access;

    @JsonProperty("bing")
    protected Boolean bing;

    @JsonProperty("excel")
    protected Boolean excel;

    @JsonProperty("groove")
    protected Boolean groove;

    @JsonProperty("infoPath")
    protected Boolean infoPath;

    @JsonProperty("lync")
    protected Boolean lync;

    @JsonProperty("oneDrive")
    protected Boolean oneDrive;

    @JsonProperty("oneNote")
    protected Boolean oneNote;

    @JsonProperty("outlook")
    protected Boolean outlook;

    @JsonProperty("powerPoint")
    protected Boolean powerPoint;

    @JsonProperty("publisher")
    protected Boolean publisher;

    @JsonProperty("sharePointDesigner")
    protected Boolean sharePointDesigner;

    @JsonProperty("teams")
    protected Boolean teams;

    @JsonProperty("visio")
    protected Boolean visio;

    @JsonProperty("word")
    protected Boolean word;

    protected ExcludedApps() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.excludedApps";
    }

    /**
     * <i>“The value for if MS Office Access should be excluded or not.”</i>
     * 
     * @return property access
     */
    @Property(name="access")
    @JsonIgnore
    public Optional<Boolean> getAccess() {
        return Optional.ofNullable(access);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code access} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The value for if MS Office Access should be excluded or not.”</i>
     * 
     * @param access
     *            new value of {@code access} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code access} field changed
     */
    public ExcludedApps withAccess(Boolean access) {
        ExcludedApps _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.excludedApps");
        _x.access = access;
        return _x;
    }

    /**
     * <i>“The value for if Microsoft Search as default should be excluded or not.”</i>
     * 
     * @return property bing
     */
    @Property(name="bing")
    @JsonIgnore
    public Optional<Boolean> getBing() {
        return Optional.ofNullable(bing);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code bing} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The value for if Microsoft Search as default should be excluded or not.”</i>
     * 
     * @param bing
     *            new value of {@code bing} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bing} field changed
     */
    public ExcludedApps withBing(Boolean bing) {
        ExcludedApps _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.excludedApps");
        _x.bing = bing;
        return _x;
    }

    /**
     * <i>“The value for if MS Office Excel should be excluded or not.”</i>
     * 
     * @return property excel
     */
    @Property(name="excel")
    @JsonIgnore
    public Optional<Boolean> getExcel() {
        return Optional.ofNullable(excel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code excel} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The value for if MS Office Excel should be excluded or not.”</i>
     * 
     * @param excel
     *            new value of {@code excel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code excel} field changed
     */
    public ExcludedApps withExcel(Boolean excel) {
        ExcludedApps _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.excludedApps");
        _x.excel = excel;
        return _x;
    }

    /**
     * <i>“The value for if MS Office OneDrive for Business - Groove should be excluded or
     * not.”</i>
     * 
     * @return property groove
     */
    @Property(name="groove")
    @JsonIgnore
    public Optional<Boolean> getGroove() {
        return Optional.ofNullable(groove);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code groove} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The value for if MS Office OneDrive for Business - Groove should be excluded or
     * not.”</i>
     * 
     * @param groove
     *            new value of {@code groove} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groove} field changed
     */
    public ExcludedApps withGroove(Boolean groove) {
        ExcludedApps _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.excludedApps");
        _x.groove = groove;
        return _x;
    }

    /**
     * <i>“The value for if MS Office InfoPath should be excluded or not.”</i>
     * 
     * @return property infoPath
     */
    @Property(name="infoPath")
    @JsonIgnore
    public Optional<Boolean> getInfoPath() {
        return Optional.ofNullable(infoPath);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code infoPath} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The value for if MS Office InfoPath should be excluded or not.”</i>
     * 
     * @param infoPath
     *            new value of {@code infoPath} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code infoPath} field changed
     */
    public ExcludedApps withInfoPath(Boolean infoPath) {
        ExcludedApps _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.excludedApps");
        _x.infoPath = infoPath;
        return _x;
    }

    /**
     * <i>“The value for if MS Office Skype for Business - Lync should be excluded or not.”</i>
     * 
     * @return property lync
     */
    @Property(name="lync")
    @JsonIgnore
    public Optional<Boolean> getLync() {
        return Optional.ofNullable(lync);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lync} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The value for if MS Office Skype for Business - Lync should be excluded or not.”</i>
     * 
     * @param lync
     *            new value of {@code lync} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lync} field changed
     */
    public ExcludedApps withLync(Boolean lync) {
        ExcludedApps _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.excludedApps");
        _x.lync = lync;
        return _x;
    }

    /**
     * <i>“The value for if MS Office OneDrive should be excluded or not.”</i>
     * 
     * @return property oneDrive
     */
    @Property(name="oneDrive")
    @JsonIgnore
    public Optional<Boolean> getOneDrive() {
        return Optional.ofNullable(oneDrive);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code oneDrive} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The value for if MS Office OneDrive should be excluded or not.”</i>
     * 
     * @param oneDrive
     *            new value of {@code oneDrive} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code oneDrive} field changed
     */
    public ExcludedApps withOneDrive(Boolean oneDrive) {
        ExcludedApps _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.excludedApps");
        _x.oneDrive = oneDrive;
        return _x;
    }

    /**
     * <i>“The value for if MS Office OneNote should be excluded or not.”</i>
     * 
     * @return property oneNote
     */
    @Property(name="oneNote")
    @JsonIgnore
    public Optional<Boolean> getOneNote() {
        return Optional.ofNullable(oneNote);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code oneNote} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The value for if MS Office OneNote should be excluded or not.”</i>
     * 
     * @param oneNote
     *            new value of {@code oneNote} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code oneNote} field changed
     */
    public ExcludedApps withOneNote(Boolean oneNote) {
        ExcludedApps _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.excludedApps");
        _x.oneNote = oneNote;
        return _x;
    }

    /**
     * <i>“The value for if MS Office Outlook should be excluded or not.”</i>
     * 
     * @return property outlook
     */
    @Property(name="outlook")
    @JsonIgnore
    public Optional<Boolean> getOutlook() {
        return Optional.ofNullable(outlook);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code outlook} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The value for if MS Office Outlook should be excluded or not.”</i>
     * 
     * @param outlook
     *            new value of {@code outlook} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code outlook} field changed
     */
    public ExcludedApps withOutlook(Boolean outlook) {
        ExcludedApps _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.excludedApps");
        _x.outlook = outlook;
        return _x;
    }

    /**
     * <i>“The value for if MS Office PowerPoint should be excluded or not.”</i>
     * 
     * @return property powerPoint
     */
    @Property(name="powerPoint")
    @JsonIgnore
    public Optional<Boolean> getPowerPoint() {
        return Optional.ofNullable(powerPoint);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code powerPoint} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The value for if MS Office PowerPoint should be excluded or not.”</i>
     * 
     * @param powerPoint
     *            new value of {@code powerPoint} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code powerPoint} field changed
     */
    public ExcludedApps withPowerPoint(Boolean powerPoint) {
        ExcludedApps _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.excludedApps");
        _x.powerPoint = powerPoint;
        return _x;
    }

    /**
     * <i>“The value for if MS Office Publisher should be excluded or not.”</i>
     * 
     * @return property publisher
     */
    @Property(name="publisher")
    @JsonIgnore
    public Optional<Boolean> getPublisher() {
        return Optional.ofNullable(publisher);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code publisher} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The value for if MS Office Publisher should be excluded or not.”</i>
     * 
     * @param publisher
     *            new value of {@code publisher} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code publisher} field changed
     */
    public ExcludedApps withPublisher(Boolean publisher) {
        ExcludedApps _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.excludedApps");
        _x.publisher = publisher;
        return _x;
    }

    /**
     * <i>“The value for if MS Office SharePointDesigner should be excluded or not.”</i>
     * 
     * @return property sharePointDesigner
     */
    @Property(name="sharePointDesigner")
    @JsonIgnore
    public Optional<Boolean> getSharePointDesigner() {
        return Optional.ofNullable(sharePointDesigner);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * sharePointDesigner} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The value for if MS Office SharePointDesigner should be excluded or not.”</i>
     * 
     * @param sharePointDesigner
     *            new value of {@code sharePointDesigner} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code sharePointDesigner} field changed
     */
    public ExcludedApps withSharePointDesigner(Boolean sharePointDesigner) {
        ExcludedApps _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.excludedApps");
        _x.sharePointDesigner = sharePointDesigner;
        return _x;
    }

    /**
     * <i>“The value for if MS Office Teams should be excluded or not.”</i>
     * 
     * @return property teams
     */
    @Property(name="teams")
    @JsonIgnore
    public Optional<Boolean> getTeams() {
        return Optional.ofNullable(teams);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code teams} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The value for if MS Office Teams should be excluded or not.”</i>
     * 
     * @param teams
     *            new value of {@code teams} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code teams} field changed
     */
    public ExcludedApps withTeams(Boolean teams) {
        ExcludedApps _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.excludedApps");
        _x.teams = teams;
        return _x;
    }

    /**
     * <i>“The value for if MS Office Visio should be excluded or not.”</i>
     * 
     * @return property visio
     */
    @Property(name="visio")
    @JsonIgnore
    public Optional<Boolean> getVisio() {
        return Optional.ofNullable(visio);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code visio} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The value for if MS Office Visio should be excluded or not.”</i>
     * 
     * @param visio
     *            new value of {@code visio} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code visio} field changed
     */
    public ExcludedApps withVisio(Boolean visio) {
        ExcludedApps _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.excludedApps");
        _x.visio = visio;
        return _x;
    }

    /**
     * <i>“The value for if MS Office Word should be excluded or not.”</i>
     * 
     * @return property word
     */
    @Property(name="word")
    @JsonIgnore
    public Optional<Boolean> getWord() {
        return Optional.ofNullable(word);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code word} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The value for if MS Office Word should be excluded or not.”</i>
     * 
     * @param word
     *            new value of {@code word} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code word} field changed
     */
    public ExcludedApps withWord(Boolean word) {
        ExcludedApps _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.excludedApps");
        _x.word = word;
        return _x;
    }

    public ExcludedApps withUnmappedField(String name, Object value) {
        ExcludedApps _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean access;
        private Boolean bing;
        private Boolean excel;
        private Boolean groove;
        private Boolean infoPath;
        private Boolean lync;
        private Boolean oneDrive;
        private Boolean oneNote;
        private Boolean outlook;
        private Boolean powerPoint;
        private Boolean publisher;
        private Boolean sharePointDesigner;
        private Boolean teams;
        private Boolean visio;
        private Boolean word;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The value for if MS Office Access should be excluded or not.”</i>
         * 
         * @param access
         *            value of {@code access} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder access(Boolean access) {
            this.access = access;
            this.changedFields = changedFields.add("access");
            return this;
        }

        /**
         * <i>“The value for if Microsoft Search as default should be excluded or not.”</i>
         * 
         * @param bing
         *            value of {@code bing} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bing(Boolean bing) {
            this.bing = bing;
            this.changedFields = changedFields.add("bing");
            return this;
        }

        /**
         * <i>“The value for if MS Office Excel should be excluded or not.”</i>
         * 
         * @param excel
         *            value of {@code excel} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder excel(Boolean excel) {
            this.excel = excel;
            this.changedFields = changedFields.add("excel");
            return this;
        }

        /**
         * <i>“The value for if MS Office OneDrive for Business - Groove should be excluded or
         * not.”</i>
         * 
         * @param groove
         *            value of {@code groove} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groove(Boolean groove) {
            this.groove = groove;
            this.changedFields = changedFields.add("groove");
            return this;
        }

        /**
         * <i>“The value for if MS Office InfoPath should be excluded or not.”</i>
         * 
         * @param infoPath
         *            value of {@code infoPath} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder infoPath(Boolean infoPath) {
            this.infoPath = infoPath;
            this.changedFields = changedFields.add("infoPath");
            return this;
        }

        /**
         * <i>“The value for if MS Office Skype for Business - Lync should be excluded or not.”</i>
         * 
         * @param lync
         *            value of {@code lync} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lync(Boolean lync) {
            this.lync = lync;
            this.changedFields = changedFields.add("lync");
            return this;
        }

        /**
         * <i>“The value for if MS Office OneDrive should be excluded or not.”</i>
         * 
         * @param oneDrive
         *            value of {@code oneDrive} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder oneDrive(Boolean oneDrive) {
            this.oneDrive = oneDrive;
            this.changedFields = changedFields.add("oneDrive");
            return this;
        }

        /**
         * <i>“The value for if MS Office OneNote should be excluded or not.”</i>
         * 
         * @param oneNote
         *            value of {@code oneNote} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder oneNote(Boolean oneNote) {
            this.oneNote = oneNote;
            this.changedFields = changedFields.add("oneNote");
            return this;
        }

        /**
         * <i>“The value for if MS Office Outlook should be excluded or not.”</i>
         * 
         * @param outlook
         *            value of {@code outlook} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder outlook(Boolean outlook) {
            this.outlook = outlook;
            this.changedFields = changedFields.add("outlook");
            return this;
        }

        /**
         * <i>“The value for if MS Office PowerPoint should be excluded or not.”</i>
         * 
         * @param powerPoint
         *            value of {@code powerPoint} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder powerPoint(Boolean powerPoint) {
            this.powerPoint = powerPoint;
            this.changedFields = changedFields.add("powerPoint");
            return this;
        }

        /**
         * <i>“The value for if MS Office Publisher should be excluded or not.”</i>
         * 
         * @param publisher
         *            value of {@code publisher} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder publisher(Boolean publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        /**
         * <i>“The value for if MS Office SharePointDesigner should be excluded or not.”</i>
         * 
         * @param sharePointDesigner
         *            value of {@code sharePointDesigner} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sharePointDesigner(Boolean sharePointDesigner) {
            this.sharePointDesigner = sharePointDesigner;
            this.changedFields = changedFields.add("sharePointDesigner");
            return this;
        }

        /**
         * <i>“The value for if MS Office Teams should be excluded or not.”</i>
         * 
         * @param teams
         *            value of {@code teams} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder teams(Boolean teams) {
            this.teams = teams;
            this.changedFields = changedFields.add("teams");
            return this;
        }

        /**
         * <i>“The value for if MS Office Visio should be excluded or not.”</i>
         * 
         * @param visio
         *            value of {@code visio} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder visio(Boolean visio) {
            this.visio = visio;
            this.changedFields = changedFields.add("visio");
            return this;
        }

        /**
         * <i>“The value for if MS Office Word should be excluded or not.”</i>
         * 
         * @param word
         *            value of {@code word} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder word(Boolean word) {
            this.word = word;
            this.changedFields = changedFields.add("word");
            return this;
        }

        public ExcludedApps build() {
            ExcludedApps _x = new ExcludedApps();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.excludedApps";
            _x.access = access;
            _x.bing = bing;
            _x.excel = excel;
            _x.groove = groove;
            _x.infoPath = infoPath;
            _x.lync = lync;
            _x.oneDrive = oneDrive;
            _x.oneNote = oneNote;
            _x.outlook = outlook;
            _x.powerPoint = powerPoint;
            _x.publisher = publisher;
            _x.sharePointDesigner = sharePointDesigner;
            _x.teams = teams;
            _x.visio = visio;
            _x.word = word;
            return _x;
        }
    }

    private ExcludedApps _copy() {
        ExcludedApps _x = new ExcludedApps();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.access = access;
        _x.bing = bing;
        _x.excel = excel;
        _x.groove = groove;
        _x.infoPath = infoPath;
        _x.lync = lync;
        _x.oneDrive = oneDrive;
        _x.oneNote = oneNote;
        _x.outlook = outlook;
        _x.powerPoint = powerPoint;
        _x.publisher = publisher;
        _x.sharePointDesigner = sharePointDesigner;
        _x.teams = teams;
        _x.visio = visio;
        _x.word = word;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExcludedApps[");
        b.append("access=");
        b.append(this.access);
        b.append(", ");
        b.append("bing=");
        b.append(this.bing);
        b.append(", ");
        b.append("excel=");
        b.append(this.excel);
        b.append(", ");
        b.append("groove=");
        b.append(this.groove);
        b.append(", ");
        b.append("infoPath=");
        b.append(this.infoPath);
        b.append(", ");
        b.append("lync=");
        b.append(this.lync);
        b.append(", ");
        b.append("oneDrive=");
        b.append(this.oneDrive);
        b.append(", ");
        b.append("oneNote=");
        b.append(this.oneNote);
        b.append(", ");
        b.append("outlook=");
        b.append(this.outlook);
        b.append(", ");
        b.append("powerPoint=");
        b.append(this.powerPoint);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("sharePointDesigner=");
        b.append(this.sharePointDesigner);
        b.append(", ");
        b.append("teams=");
        b.append(this.teams);
        b.append(", ");
        b.append("visio=");
        b.append(this.visio);
        b.append(", ");
        b.append("word=");
        b.append(this.word);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
