package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "matches"})
@JsonInclude(Include.NON_NULL)
public class ExactMatchDetectedSensitiveContent extends DetectedSensitiveContentBase implements ODataType {

    @JsonProperty("matches")
    protected List<SensitiveContentLocation> matches;

    @JsonProperty("matches@nextLink")
    protected String matchesNextLink;

    protected ExactMatchDetectedSensitiveContent() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.exactMatchDetectedSensitiveContent";
    }

    @Property(name="matches")
    @JsonIgnore
    public CollectionPage<SensitiveContentLocation> getMatches() {
        return new CollectionPage<SensitiveContentLocation>(contextPath, SensitiveContentLocation.class, this.matches, Optional.ofNullable(matchesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="matches")
    @JsonIgnore
    public CollectionPage<SensitiveContentLocation> getMatches(HttpRequestOptions options) {
        return new CollectionPage<SensitiveContentLocation>(contextPath, SensitiveContentLocation.class, this.matches, Optional.ofNullable(matchesNextLink), Collections.emptyList(), options);
    }

    public ExactMatchDetectedSensitiveContent withUnmappedField(String name, Object value) {
        ExactMatchDetectedSensitiveContent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderExactMatchDetectedSensitiveContent() {
        return new Builder();
    }

    public static final class Builder {
        private Integer confidence;
        private String displayName;
        private UUID id;
        private Integer recommendedConfidence;
        private Integer uniqueCount;
        private List<SensitiveContentLocation> matches;
        private String matchesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder confidence(Integer confidence) {
            this.confidence = confidence;
            this.changedFields = changedFields.add("confidence");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder id(UUID id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder recommendedConfidence(Integer recommendedConfidence) {
            this.recommendedConfidence = recommendedConfidence;
            this.changedFields = changedFields.add("recommendedConfidence");
            return this;
        }

        public Builder uniqueCount(Integer uniqueCount) {
            this.uniqueCount = uniqueCount;
            this.changedFields = changedFields.add("uniqueCount");
            return this;
        }

        public Builder matches(List<SensitiveContentLocation> matches) {
            this.matches = matches;
            this.changedFields = changedFields.add("matches");
            return this;
        }

        public Builder matches(SensitiveContentLocation... matches) {
            return matches(Arrays.asList(matches));
        }

        public Builder matchesNextLink(String matchesNextLink) {
            this.matchesNextLink = matchesNextLink;
            this.changedFields = changedFields.add("matches");
            return this;
        }

        public ExactMatchDetectedSensitiveContent build() {
            ExactMatchDetectedSensitiveContent _x = new ExactMatchDetectedSensitiveContent();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.exactMatchDetectedSensitiveContent";
            _x.confidence = confidence;
            _x.displayName = displayName;
            _x.id = id;
            _x.recommendedConfidence = recommendedConfidence;
            _x.uniqueCount = uniqueCount;
            _x.matches = matches;
            _x.matchesNextLink = matchesNextLink;
            return _x;
        }
    }

    private ExactMatchDetectedSensitiveContent _copy() {
        ExactMatchDetectedSensitiveContent _x = new ExactMatchDetectedSensitiveContent();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.confidence = confidence;
        _x.displayName = displayName;
        _x.id = id;
        _x.recommendedConfidence = recommendedConfidence;
        _x.uniqueCount = uniqueCount;
        _x.matches = matches;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExactMatchDetectedSensitiveContent[");
        b.append("confidence=");
        b.append(this.confidence);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("recommendedConfidence=");
        b.append(this.recommendedConfidence);
        b.append(", ");
        b.append("uniqueCount=");
        b.append(this.uniqueCount);
        b.append(", ");
        b.append("matches=");
        b.append(this.matches);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
