package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "responsiblePolicy", 
    "responsibleSensitiveTypes", 
    "sensitivityLabel"})
@JsonInclude(Include.NON_NULL)
public class EvaluateLabelJobResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("responsiblePolicy")
    protected ResponsiblePolicy responsiblePolicy;

    @JsonProperty("responsibleSensitiveTypes")
    protected List<ResponsibleSensitiveType> responsibleSensitiveTypes;

    @JsonProperty("responsibleSensitiveTypes@nextLink")
    protected String responsibleSensitiveTypesNextLink;

    @JsonProperty("sensitivityLabel")
    protected MatchingLabel sensitivityLabel;

    protected EvaluateLabelJobResult() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.evaluateLabelJobResult";
    }

    @Property(name="responsiblePolicy")
    @JsonIgnore
    public Optional<ResponsiblePolicy> getResponsiblePolicy() {
        return Optional.ofNullable(responsiblePolicy);
    }

    public EvaluateLabelJobResult withResponsiblePolicy(ResponsiblePolicy responsiblePolicy) {
        EvaluateLabelJobResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.evaluateLabelJobResult");
        _x.responsiblePolicy = responsiblePolicy;
        return _x;
    }

    @Property(name="responsibleSensitiveTypes")
    @JsonIgnore
    public CollectionPage<ResponsibleSensitiveType> getResponsibleSensitiveTypes() {
        return new CollectionPage<ResponsibleSensitiveType>(contextPath, ResponsibleSensitiveType.class, this.responsibleSensitiveTypes, Optional.ofNullable(responsibleSensitiveTypesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="responsibleSensitiveTypes")
    @JsonIgnore
    public CollectionPage<ResponsibleSensitiveType> getResponsibleSensitiveTypes(HttpRequestOptions options) {
        return new CollectionPage<ResponsibleSensitiveType>(contextPath, ResponsibleSensitiveType.class, this.responsibleSensitiveTypes, Optional.ofNullable(responsibleSensitiveTypesNextLink), Collections.emptyList(), options);
    }

    @Property(name="sensitivityLabel")
    @JsonIgnore
    public Optional<MatchingLabel> getSensitivityLabel() {
        return Optional.ofNullable(sensitivityLabel);
    }

    public EvaluateLabelJobResult withSensitivityLabel(MatchingLabel sensitivityLabel) {
        EvaluateLabelJobResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.evaluateLabelJobResult");
        _x.sensitivityLabel = sensitivityLabel;
        return _x;
    }

    public EvaluateLabelJobResult withUnmappedField(String name, Object value) {
        EvaluateLabelJobResult _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ResponsiblePolicy responsiblePolicy;
        private List<ResponsibleSensitiveType> responsibleSensitiveTypes;
        private String responsibleSensitiveTypesNextLink;
        private MatchingLabel sensitivityLabel;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder responsiblePolicy(ResponsiblePolicy responsiblePolicy) {
            this.responsiblePolicy = responsiblePolicy;
            this.changedFields = changedFields.add("responsiblePolicy");
            return this;
        }

        public Builder responsibleSensitiveTypes(List<ResponsibleSensitiveType> responsibleSensitiveTypes) {
            this.responsibleSensitiveTypes = responsibleSensitiveTypes;
            this.changedFields = changedFields.add("responsibleSensitiveTypes");
            return this;
        }

        public Builder responsibleSensitiveTypes(ResponsibleSensitiveType... responsibleSensitiveTypes) {
            return responsibleSensitiveTypes(Arrays.asList(responsibleSensitiveTypes));
        }

        public Builder responsibleSensitiveTypesNextLink(String responsibleSensitiveTypesNextLink) {
            this.responsibleSensitiveTypesNextLink = responsibleSensitiveTypesNextLink;
            this.changedFields = changedFields.add("responsibleSensitiveTypes");
            return this;
        }

        public Builder sensitivityLabel(MatchingLabel sensitivityLabel) {
            this.sensitivityLabel = sensitivityLabel;
            this.changedFields = changedFields.add("sensitivityLabel");
            return this;
        }

        public EvaluateLabelJobResult build() {
            EvaluateLabelJobResult _x = new EvaluateLabelJobResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.evaluateLabelJobResult";
            _x.responsiblePolicy = responsiblePolicy;
            _x.responsibleSensitiveTypes = responsibleSensitiveTypes;
            _x.responsibleSensitiveTypesNextLink = responsibleSensitiveTypesNextLink;
            _x.sensitivityLabel = sensitivityLabel;
            return _x;
        }
    }

    private EvaluateLabelJobResult _copy() {
        EvaluateLabelJobResult _x = new EvaluateLabelJobResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.responsiblePolicy = responsiblePolicy;
        _x.responsibleSensitiveTypes = responsibleSensitiveTypes;
        _x.sensitivityLabel = sensitivityLabel;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EvaluateLabelJobResult[");
        b.append("responsiblePolicy=");
        b.append(this.responsiblePolicy);
        b.append(", ");
        b.append("responsibleSensitiveTypes=");
        b.append(this.responsibleSensitiveTypes);
        b.append(", ");
        b.append("sensitivityLabel=");
        b.append(this.sensitivityLabel);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
