package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "membershipRule", 
    "membershipRuleEvaluationDetails", 
    "membershipRuleEvaluationResult"})
@JsonInclude(Include.NON_NULL)
public class EvaluateDynamicMembershipResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("membershipRule")
    protected String membershipRule;

    @JsonProperty("membershipRuleEvaluationDetails")
    protected ExpressionEvaluationDetails membershipRuleEvaluationDetails;

    @JsonProperty("membershipRuleEvaluationResult")
    protected Boolean membershipRuleEvaluationResult;

    protected EvaluateDynamicMembershipResult() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.evaluateDynamicMembershipResult";
    }

    @Property(name="membershipRule")
    @JsonIgnore
    public Optional<String> getMembershipRule() {
        return Optional.ofNullable(membershipRule);
    }

    public EvaluateDynamicMembershipResult withMembershipRule(String membershipRule) {
        EvaluateDynamicMembershipResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.evaluateDynamicMembershipResult");
        _x.membershipRule = membershipRule;
        return _x;
    }

    @Property(name="membershipRuleEvaluationDetails")
    @JsonIgnore
    public Optional<ExpressionEvaluationDetails> getMembershipRuleEvaluationDetails() {
        return Optional.ofNullable(membershipRuleEvaluationDetails);
    }

    public EvaluateDynamicMembershipResult withMembershipRuleEvaluationDetails(ExpressionEvaluationDetails membershipRuleEvaluationDetails) {
        EvaluateDynamicMembershipResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.evaluateDynamicMembershipResult");
        _x.membershipRuleEvaluationDetails = membershipRuleEvaluationDetails;
        return _x;
    }

    @Property(name="membershipRuleEvaluationResult")
    @JsonIgnore
    public Optional<Boolean> getMembershipRuleEvaluationResult() {
        return Optional.ofNullable(membershipRuleEvaluationResult);
    }

    public EvaluateDynamicMembershipResult withMembershipRuleEvaluationResult(Boolean membershipRuleEvaluationResult) {
        EvaluateDynamicMembershipResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.evaluateDynamicMembershipResult");
        _x.membershipRuleEvaluationResult = membershipRuleEvaluationResult;
        return _x;
    }

    public EvaluateDynamicMembershipResult withUnmappedField(String name, Object value) {
        EvaluateDynamicMembershipResult _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String membershipRule;
        private ExpressionEvaluationDetails membershipRuleEvaluationDetails;
        private Boolean membershipRuleEvaluationResult;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder membershipRule(String membershipRule) {
            this.membershipRule = membershipRule;
            this.changedFields = changedFields.add("membershipRule");
            return this;
        }

        public Builder membershipRuleEvaluationDetails(ExpressionEvaluationDetails membershipRuleEvaluationDetails) {
            this.membershipRuleEvaluationDetails = membershipRuleEvaluationDetails;
            this.changedFields = changedFields.add("membershipRuleEvaluationDetails");
            return this;
        }

        public Builder membershipRuleEvaluationResult(Boolean membershipRuleEvaluationResult) {
            this.membershipRuleEvaluationResult = membershipRuleEvaluationResult;
            this.changedFields = changedFields.add("membershipRuleEvaluationResult");
            return this;
        }

        public EvaluateDynamicMembershipResult build() {
            EvaluateDynamicMembershipResult _x = new EvaluateDynamicMembershipResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.evaluateDynamicMembershipResult";
            _x.membershipRule = membershipRule;
            _x.membershipRuleEvaluationDetails = membershipRuleEvaluationDetails;
            _x.membershipRuleEvaluationResult = membershipRuleEvaluationResult;
            return _x;
        }
    }

    private EvaluateDynamicMembershipResult _copy() {
        EvaluateDynamicMembershipResult _x = new EvaluateDynamicMembershipResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.membershipRule = membershipRule;
        _x.membershipRuleEvaluationDetails = membershipRuleEvaluationDetails;
        _x.membershipRuleEvaluationResult = membershipRuleEvaluationResult;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EvaluateDynamicMembershipResult[");
        b.append("membershipRule=");
        b.append(this.membershipRule);
        b.append(", ");
        b.append("membershipRuleEvaluationDetails=");
        b.append(this.membershipRuleEvaluationDetails);
        b.append(", ");
        b.append("membershipRuleEvaluationResult=");
        b.append(this.membershipRuleEvaluationResult);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
