package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.EncryptWith;

@JsonPropertyOrder({
    "@odata.type", 
    "availableForEncryption", 
    "templateId"})
@JsonInclude(Include.NON_NULL)
public class EncryptWithTemplate extends EncryptContent implements ODataType {

    @JsonProperty("availableForEncryption")
    protected Boolean availableForEncryption;

    @JsonProperty("templateId")
    protected String templateId;

    protected EncryptWithTemplate() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.encryptWithTemplate";
    }

    @Property(name="availableForEncryption")
    @JsonIgnore
    public Optional<Boolean> getAvailableForEncryption() {
        return Optional.ofNullable(availableForEncryption);
    }

    public EncryptWithTemplate withAvailableForEncryption(Boolean availableForEncryption) {
        EncryptWithTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.encryptWithTemplate");
        _x.availableForEncryption = availableForEncryption;
        return _x;
    }

    @Property(name="templateId")
    @JsonIgnore
    public Optional<String> getTemplateId() {
        return Optional.ofNullable(templateId);
    }

    public EncryptWithTemplate withTemplateId(String templateId) {
        EncryptWithTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.encryptWithTemplate");
        _x.templateId = templateId;
        return _x;
    }

    public EncryptWithTemplate withUnmappedField(String name, Object value) {
        EncryptWithTemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEncryptWithTemplate() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private EncryptWith encryptWith;
        private Boolean availableForEncryption;
        private String templateId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder encryptWith(EncryptWith encryptWith) {
            this.encryptWith = encryptWith;
            this.changedFields = changedFields.add("encryptWith");
            return this;
        }

        public Builder availableForEncryption(Boolean availableForEncryption) {
            this.availableForEncryption = availableForEncryption;
            this.changedFields = changedFields.add("availableForEncryption");
            return this;
        }

        public Builder templateId(String templateId) {
            this.templateId = templateId;
            this.changedFields = changedFields.add("templateId");
            return this;
        }

        public EncryptWithTemplate build() {
            EncryptWithTemplate _x = new EncryptWithTemplate();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.encryptWithTemplate";
            _x.name = name;
            _x.encryptWith = encryptWith;
            _x.availableForEncryption = availableForEncryption;
            _x.templateId = templateId;
            return _x;
        }
    }

    private EncryptWithTemplate _copy() {
        EncryptWithTemplate _x = new EncryptWithTemplate();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.name = name;
        _x.encryptWith = encryptWith;
        _x.availableForEncryption = availableForEncryption;
        _x.templateId = templateId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EncryptWithTemplate[");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("encryptWith=");
        b.append(this.encryptWith);
        b.append(", ");
        b.append("availableForEncryption=");
        b.append(this.availableForEncryption);
        b.append(", ");
        b.append("templateId=");
        b.append(this.templateId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
