package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.EncryptWith;

@JsonPropertyOrder({
    "@odata.type", 
    "encryptWith"})
@JsonInclude(Include.NON_NULL)
public class EncryptContent extends LabelActionBase implements ODataType {

    @JsonProperty("encryptWith")
    protected EncryptWith encryptWith;

    protected EncryptContent() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.encryptContent";
    }

    @Property(name="encryptWith")
    @JsonIgnore
    public Optional<EncryptWith> getEncryptWith() {
        return Optional.ofNullable(encryptWith);
    }

    public EncryptContent withEncryptWith(EncryptWith encryptWith) {
        EncryptContent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.encryptContent");
        _x.encryptWith = encryptWith;
        return _x;
    }

    public EncryptContent withUnmappedField(String name, Object value) {
        EncryptContent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    private EncryptContent _copy() {
        EncryptContent _x = new EncryptContent();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.name = name;
        _x.encryptWith = encryptWith;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EncryptContent[");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("encryptWith=");
        b.append(this.encryptWith);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
