package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "abbreviation", 
    "activities", 
    "awards", 
    "description", 
    "displayName", 
    "fieldsOfStudy", 
    "grade", 
    "notes", 
    "webUrl"})
@JsonInclude(Include.NON_NULL)
public class EducationalActivityDetail implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("abbreviation")
    protected String abbreviation;

    @JsonProperty("activities")
    protected List<String> activities;

    @JsonProperty("activities@nextLink")
    protected String activitiesNextLink;

    @JsonProperty("awards")
    protected List<String> awards;

    @JsonProperty("awards@nextLink")
    protected String awardsNextLink;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("fieldsOfStudy")
    protected List<String> fieldsOfStudy;

    @JsonProperty("fieldsOfStudy@nextLink")
    protected String fieldsOfStudyNextLink;

    @JsonProperty("grade")
    protected String grade;

    @JsonProperty("notes")
    protected String notes;

    @JsonProperty("webUrl")
    protected String webUrl;

    protected EducationalActivityDetail() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationalActivityDetail";
    }

    @Property(name="abbreviation")
    @JsonIgnore
    public Optional<String> getAbbreviation() {
        return Optional.ofNullable(abbreviation);
    }

    public EducationalActivityDetail withAbbreviation(String abbreviation) {
        EducationalActivityDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationalActivityDetail");
        _x.abbreviation = abbreviation;
        return _x;
    }

    @Property(name="activities")
    @JsonIgnore
    public CollectionPage<String> getActivities() {
        return new CollectionPage<String>(contextPath, String.class, this.activities, Optional.ofNullable(activitiesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="activities")
    @JsonIgnore
    public CollectionPage<String> getActivities(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.activities, Optional.ofNullable(activitiesNextLink), Collections.emptyList(), options);
    }

    @Property(name="awards")
    @JsonIgnore
    public CollectionPage<String> getAwards() {
        return new CollectionPage<String>(contextPath, String.class, this.awards, Optional.ofNullable(awardsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="awards")
    @JsonIgnore
    public CollectionPage<String> getAwards(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.awards, Optional.ofNullable(awardsNextLink), Collections.emptyList(), options);
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public EducationalActivityDetail withDescription(String description) {
        EducationalActivityDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationalActivityDetail");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public EducationalActivityDetail withDisplayName(String displayName) {
        EducationalActivityDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationalActivityDetail");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="fieldsOfStudy")
    @JsonIgnore
    public CollectionPage<String> getFieldsOfStudy() {
        return new CollectionPage<String>(contextPath, String.class, this.fieldsOfStudy, Optional.ofNullable(fieldsOfStudyNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="fieldsOfStudy")
    @JsonIgnore
    public CollectionPage<String> getFieldsOfStudy(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.fieldsOfStudy, Optional.ofNullable(fieldsOfStudyNextLink), Collections.emptyList(), options);
    }

    @Property(name="grade")
    @JsonIgnore
    public Optional<String> getGrade() {
        return Optional.ofNullable(grade);
    }

    public EducationalActivityDetail withGrade(String grade) {
        EducationalActivityDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationalActivityDetail");
        _x.grade = grade;
        return _x;
    }

    @Property(name="notes")
    @JsonIgnore
    public Optional<String> getNotes() {
        return Optional.ofNullable(notes);
    }

    public EducationalActivityDetail withNotes(String notes) {
        EducationalActivityDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationalActivityDetail");
        _x.notes = notes;
        return _x;
    }

    @Property(name="webUrl")
    @JsonIgnore
    public Optional<String> getWebUrl() {
        return Optional.ofNullable(webUrl);
    }

    public EducationalActivityDetail withWebUrl(String webUrl) {
        EducationalActivityDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationalActivityDetail");
        _x.webUrl = webUrl;
        return _x;
    }

    public EducationalActivityDetail withUnmappedField(String name, Object value) {
        EducationalActivityDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String abbreviation;
        private List<String> activities;
        private String activitiesNextLink;
        private List<String> awards;
        private String awardsNextLink;
        private String description;
        private String displayName;
        private List<String> fieldsOfStudy;
        private String fieldsOfStudyNextLink;
        private String grade;
        private String notes;
        private String webUrl;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder abbreviation(String abbreviation) {
            this.abbreviation = abbreviation;
            this.changedFields = changedFields.add("abbreviation");
            return this;
        }

        public Builder activities(List<String> activities) {
            this.activities = activities;
            this.changedFields = changedFields.add("activities");
            return this;
        }

        public Builder activities(String... activities) {
            return activities(Arrays.asList(activities));
        }

        public Builder activitiesNextLink(String activitiesNextLink) {
            this.activitiesNextLink = activitiesNextLink;
            this.changedFields = changedFields.add("activities");
            return this;
        }

        public Builder awards(List<String> awards) {
            this.awards = awards;
            this.changedFields = changedFields.add("awards");
            return this;
        }

        public Builder awards(String... awards) {
            return awards(Arrays.asList(awards));
        }

        public Builder awardsNextLink(String awardsNextLink) {
            this.awardsNextLink = awardsNextLink;
            this.changedFields = changedFields.add("awards");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder fieldsOfStudy(List<String> fieldsOfStudy) {
            this.fieldsOfStudy = fieldsOfStudy;
            this.changedFields = changedFields.add("fieldsOfStudy");
            return this;
        }

        public Builder fieldsOfStudy(String... fieldsOfStudy) {
            return fieldsOfStudy(Arrays.asList(fieldsOfStudy));
        }

        public Builder fieldsOfStudyNextLink(String fieldsOfStudyNextLink) {
            this.fieldsOfStudyNextLink = fieldsOfStudyNextLink;
            this.changedFields = changedFields.add("fieldsOfStudy");
            return this;
        }

        public Builder grade(String grade) {
            this.grade = grade;
            this.changedFields = changedFields.add("grade");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            this.changedFields = changedFields.add("webUrl");
            return this;
        }

        public EducationalActivityDetail build() {
            EducationalActivityDetail _x = new EducationalActivityDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.educationalActivityDetail";
            _x.abbreviation = abbreviation;
            _x.activities = activities;
            _x.activitiesNextLink = activitiesNextLink;
            _x.awards = awards;
            _x.awardsNextLink = awardsNextLink;
            _x.description = description;
            _x.displayName = displayName;
            _x.fieldsOfStudy = fieldsOfStudy;
            _x.fieldsOfStudyNextLink = fieldsOfStudyNextLink;
            _x.grade = grade;
            _x.notes = notes;
            _x.webUrl = webUrl;
            return _x;
        }
    }

    private EducationalActivityDetail _copy() {
        EducationalActivityDetail _x = new EducationalActivityDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.abbreviation = abbreviation;
        _x.activities = activities;
        _x.awards = awards;
        _x.description = description;
        _x.displayName = displayName;
        _x.fieldsOfStudy = fieldsOfStudy;
        _x.grade = grade;
        _x.notes = notes;
        _x.webUrl = webUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationalActivityDetail[");
        b.append("abbreviation=");
        b.append(this.abbreviation);
        b.append(", ");
        b.append("activities=");
        b.append(this.activities);
        b.append(", ");
        b.append("awards=");
        b.append(this.awards);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("fieldsOfStudy=");
        b.append(this.fieldsOfStudy);
        b.append(", ");
        b.append("grade=");
        b.append(this.grade);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("webUrl=");
        b.append(this.webUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
