package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.EducationUserRole;

@JsonPropertyOrder({
    "@odata.type", 
    "appliesTo", 
    "skuIds"})
@JsonInclude(Include.NON_NULL)
public class EducationSynchronizationLicenseAssignment implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("appliesTo")
    protected EducationUserRole appliesTo;

    @JsonProperty("skuIds")
    protected List<String> skuIds;

    @JsonProperty("skuIds@nextLink")
    protected String skuIdsNextLink;

    protected EducationSynchronizationLicenseAssignment() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationSynchronizationLicenseAssignment";
    }

    @Property(name="appliesTo")
    @JsonIgnore
    public Optional<EducationUserRole> getAppliesTo() {
        return Optional.ofNullable(appliesTo);
    }

    public EducationSynchronizationLicenseAssignment withAppliesTo(EducationUserRole appliesTo) {
        EducationSynchronizationLicenseAssignment _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSynchronizationLicenseAssignment");
        _x.appliesTo = appliesTo;
        return _x;
    }

    @Property(name="skuIds")
    @JsonIgnore
    public CollectionPage<String> getSkuIds() {
        return new CollectionPage<String>(contextPath, String.class, this.skuIds, Optional.ofNullable(skuIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="skuIds")
    @JsonIgnore
    public CollectionPage<String> getSkuIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.skuIds, Optional.ofNullable(skuIdsNextLink), Collections.emptyList(), options);
    }

    public EducationSynchronizationLicenseAssignment withUnmappedField(String name, Object value) {
        EducationSynchronizationLicenseAssignment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private EducationUserRole appliesTo;
        private List<String> skuIds;
        private String skuIdsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder appliesTo(EducationUserRole appliesTo) {
            this.appliesTo = appliesTo;
            this.changedFields = changedFields.add("appliesTo");
            return this;
        }

        public Builder skuIds(List<String> skuIds) {
            this.skuIds = skuIds;
            this.changedFields = changedFields.add("skuIds");
            return this;
        }

        public Builder skuIds(String... skuIds) {
            return skuIds(Arrays.asList(skuIds));
        }

        public Builder skuIdsNextLink(String skuIdsNextLink) {
            this.skuIdsNextLink = skuIdsNextLink;
            this.changedFields = changedFields.add("skuIds");
            return this;
        }

        public EducationSynchronizationLicenseAssignment build() {
            EducationSynchronizationLicenseAssignment _x = new EducationSynchronizationLicenseAssignment();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.educationSynchronizationLicenseAssignment";
            _x.appliesTo = appliesTo;
            _x.skuIds = skuIds;
            _x.skuIdsNextLink = skuIdsNextLink;
            return _x;
        }
    }

    private EducationSynchronizationLicenseAssignment _copy() {
        EducationSynchronizationLicenseAssignment _x = new EducationSynchronizationLicenseAssignment();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.appliesTo = appliesTo;
        _x.skuIds = skuIds;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationSynchronizationLicenseAssignment[");
        b.append("appliesTo=");
        b.append(this.appliesTo);
        b.append(", ");
        b.append("skuIds=");
        b.append(this.skuIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
