package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "allowDisplayNameUpdate", 
    "isSyncDeferred", 
    "optionalPropertiesToSync", 
    "synchronizationStartDate"})
@JsonInclude(Include.NON_NULL)
public class EducationSynchronizationCustomization implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("allowDisplayNameUpdate")
    protected Boolean allowDisplayNameUpdate;

    @JsonProperty("isSyncDeferred")
    protected Boolean isSyncDeferred;

    @JsonProperty("optionalPropertiesToSync")
    protected List<String> optionalPropertiesToSync;

    @JsonProperty("optionalPropertiesToSync@nextLink")
    protected String optionalPropertiesToSyncNextLink;

    @JsonProperty("synchronizationStartDate")
    protected OffsetDateTime synchronizationStartDate;

    protected EducationSynchronizationCustomization() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationSynchronizationCustomization";
    }

    @Property(name="allowDisplayNameUpdate")
    @JsonIgnore
    public Optional<Boolean> getAllowDisplayNameUpdate() {
        return Optional.ofNullable(allowDisplayNameUpdate);
    }

    public EducationSynchronizationCustomization withAllowDisplayNameUpdate(Boolean allowDisplayNameUpdate) {
        EducationSynchronizationCustomization _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSynchronizationCustomization");
        _x.allowDisplayNameUpdate = allowDisplayNameUpdate;
        return _x;
    }

    @Property(name="isSyncDeferred")
    @JsonIgnore
    public Optional<Boolean> getIsSyncDeferred() {
        return Optional.ofNullable(isSyncDeferred);
    }

    public EducationSynchronizationCustomization withIsSyncDeferred(Boolean isSyncDeferred) {
        EducationSynchronizationCustomization _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSynchronizationCustomization");
        _x.isSyncDeferred = isSyncDeferred;
        return _x;
    }

    @Property(name="optionalPropertiesToSync")
    @JsonIgnore
    public CollectionPage<String> getOptionalPropertiesToSync() {
        return new CollectionPage<String>(contextPath, String.class, this.optionalPropertiesToSync, Optional.ofNullable(optionalPropertiesToSyncNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="optionalPropertiesToSync")
    @JsonIgnore
    public CollectionPage<String> getOptionalPropertiesToSync(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.optionalPropertiesToSync, Optional.ofNullable(optionalPropertiesToSyncNextLink), Collections.emptyList(), options);
    }

    @Property(name="synchronizationStartDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getSynchronizationStartDate() {
        return Optional.ofNullable(synchronizationStartDate);
    }

    public EducationSynchronizationCustomization withSynchronizationStartDate(OffsetDateTime synchronizationStartDate) {
        EducationSynchronizationCustomization _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSynchronizationCustomization");
        _x.synchronizationStartDate = synchronizationStartDate;
        return _x;
    }

    public EducationSynchronizationCustomization withUnmappedField(String name, Object value) {
        EducationSynchronizationCustomization _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean allowDisplayNameUpdate;
        private Boolean isSyncDeferred;
        private List<String> optionalPropertiesToSync;
        private String optionalPropertiesToSyncNextLink;
        private OffsetDateTime synchronizationStartDate;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder allowDisplayNameUpdate(Boolean allowDisplayNameUpdate) {
            this.allowDisplayNameUpdate = allowDisplayNameUpdate;
            this.changedFields = changedFields.add("allowDisplayNameUpdate");
            return this;
        }

        public Builder isSyncDeferred(Boolean isSyncDeferred) {
            this.isSyncDeferred = isSyncDeferred;
            this.changedFields = changedFields.add("isSyncDeferred");
            return this;
        }

        public Builder optionalPropertiesToSync(List<String> optionalPropertiesToSync) {
            this.optionalPropertiesToSync = optionalPropertiesToSync;
            this.changedFields = changedFields.add("optionalPropertiesToSync");
            return this;
        }

        public Builder optionalPropertiesToSync(String... optionalPropertiesToSync) {
            return optionalPropertiesToSync(Arrays.asList(optionalPropertiesToSync));
        }

        public Builder optionalPropertiesToSyncNextLink(String optionalPropertiesToSyncNextLink) {
            this.optionalPropertiesToSyncNextLink = optionalPropertiesToSyncNextLink;
            this.changedFields = changedFields.add("optionalPropertiesToSync");
            return this;
        }

        public Builder synchronizationStartDate(OffsetDateTime synchronizationStartDate) {
            this.synchronizationStartDate = synchronizationStartDate;
            this.changedFields = changedFields.add("synchronizationStartDate");
            return this;
        }

        public EducationSynchronizationCustomization build() {
            EducationSynchronizationCustomization _x = new EducationSynchronizationCustomization();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.educationSynchronizationCustomization";
            _x.allowDisplayNameUpdate = allowDisplayNameUpdate;
            _x.isSyncDeferred = isSyncDeferred;
            _x.optionalPropertiesToSync = optionalPropertiesToSync;
            _x.optionalPropertiesToSyncNextLink = optionalPropertiesToSyncNextLink;
            _x.synchronizationStartDate = synchronizationStartDate;
            return _x;
        }
    }

    private EducationSynchronizationCustomization _copy() {
        EducationSynchronizationCustomization _x = new EducationSynchronizationCustomization();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.allowDisplayNameUpdate = allowDisplayNameUpdate;
        _x.isSyncDeferred = isSyncDeferred;
        _x.optionalPropertiesToSync = optionalPropertiesToSync;
        _x.synchronizationStartDate = synchronizationStartDate;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationSynchronizationCustomization[");
        b.append("allowDisplayNameUpdate=");
        b.append(this.allowDisplayNameUpdate);
        b.append(", ");
        b.append("isSyncDeferred=");
        b.append(this.isSyncDeferred);
        b.append(", ");
        b.append("optionalPropertiesToSync=");
        b.append(this.optionalPropertiesToSync);
        b.append(", ");
        b.append("synchronizationStartDate=");
        b.append(this.synchronizationStartDate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
