package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.LocalDate;
import java.util.Optional;

import odata.msgraph.client.beta.enums.EducationGender;

@JsonPropertyOrder({
    "@odata.type", 
    "birthDate", 
    "externalId", 
    "gender", 
    "grade", 
    "graduationYear", 
    "studentNumber"})
@JsonInclude(Include.NON_NULL)
public class EducationStudent implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("birthDate")
    protected LocalDate birthDate;

    @JsonProperty("externalId")
    protected String externalId;

    @JsonProperty("gender")
    protected EducationGender gender;

    @JsonProperty("grade")
    protected String grade;

    @JsonProperty("graduationYear")
    protected String graduationYear;

    @JsonProperty("studentNumber")
    protected String studentNumber;

    protected EducationStudent() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationStudent";
    }

    @Property(name="birthDate")
    @JsonIgnore
    public Optional<LocalDate> getBirthDate() {
        return Optional.ofNullable(birthDate);
    }

    public EducationStudent withBirthDate(LocalDate birthDate) {
        EducationStudent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationStudent");
        _x.birthDate = birthDate;
        return _x;
    }

    @Property(name="externalId")
    @JsonIgnore
    public Optional<String> getExternalId() {
        return Optional.ofNullable(externalId);
    }

    public EducationStudent withExternalId(String externalId) {
        EducationStudent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationStudent");
        _x.externalId = externalId;
        return _x;
    }

    @Property(name="gender")
    @JsonIgnore
    public Optional<EducationGender> getGender() {
        return Optional.ofNullable(gender);
    }

    public EducationStudent withGender(EducationGender gender) {
        EducationStudent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationStudent");
        _x.gender = gender;
        return _x;
    }

    @Property(name="grade")
    @JsonIgnore
    public Optional<String> getGrade() {
        return Optional.ofNullable(grade);
    }

    public EducationStudent withGrade(String grade) {
        EducationStudent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationStudent");
        _x.grade = grade;
        return _x;
    }

    @Property(name="graduationYear")
    @JsonIgnore
    public Optional<String> getGraduationYear() {
        return Optional.ofNullable(graduationYear);
    }

    public EducationStudent withGraduationYear(String graduationYear) {
        EducationStudent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationStudent");
        _x.graduationYear = graduationYear;
        return _x;
    }

    @Property(name="studentNumber")
    @JsonIgnore
    public Optional<String> getStudentNumber() {
        return Optional.ofNullable(studentNumber);
    }

    public EducationStudent withStudentNumber(String studentNumber) {
        EducationStudent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationStudent");
        _x.studentNumber = studentNumber;
        return _x;
    }

    public EducationStudent withUnmappedField(String name, Object value) {
        EducationStudent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private LocalDate birthDate;
        private String externalId;
        private EducationGender gender;
        private String grade;
        private String graduationYear;
        private String studentNumber;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder birthDate(LocalDate birthDate) {
            this.birthDate = birthDate;
            this.changedFields = changedFields.add("birthDate");
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = externalId;
            this.changedFields = changedFields.add("externalId");
            return this;
        }

        public Builder gender(EducationGender gender) {
            this.gender = gender;
            this.changedFields = changedFields.add("gender");
            return this;
        }

        public Builder grade(String grade) {
            this.grade = grade;
            this.changedFields = changedFields.add("grade");
            return this;
        }

        public Builder graduationYear(String graduationYear) {
            this.graduationYear = graduationYear;
            this.changedFields = changedFields.add("graduationYear");
            return this;
        }

        public Builder studentNumber(String studentNumber) {
            this.studentNumber = studentNumber;
            this.changedFields = changedFields.add("studentNumber");
            return this;
        }

        public EducationStudent build() {
            EducationStudent _x = new EducationStudent();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.educationStudent";
            _x.birthDate = birthDate;
            _x.externalId = externalId;
            _x.gender = gender;
            _x.grade = grade;
            _x.graduationYear = graduationYear;
            _x.studentNumber = studentNumber;
            return _x;
        }
    }

    private EducationStudent _copy() {
        EducationStudent _x = new EducationStudent();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.birthDate = birthDate;
        _x.externalId = externalId;
        _x.gender = gender;
        _x.grade = grade;
        _x.graduationYear = graduationYear;
        _x.studentNumber = studentNumber;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationStudent[");
        b.append("birthDate=");
        b.append(this.birthDate);
        b.append(", ");
        b.append("externalId=");
        b.append(this.externalId);
        b.append(", ");
        b.append("gender=");
        b.append(this.gender);
        b.append(", ");
        b.append("grade=");
        b.append(this.grade);
        b.append(", ");
        b.append("graduationYear=");
        b.append(this.graduationYear);
        b.append(", ");
        b.append("studentNumber=");
        b.append(this.studentNumber);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
