package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "allowTeachersInMultipleSchools", 
    "clientId", 
    "clientSecret", 
    "connectionUrl", 
    "customizations", 
    "schoolsIds", 
    "schoolYear"})
@JsonInclude(Include.NON_NULL)
public class EducationPowerSchoolDataProvider extends EducationSynchronizationDataProvider implements ODataType {

    @JsonProperty("allowTeachersInMultipleSchools")
    protected Boolean allowTeachersInMultipleSchools;

    @JsonProperty("clientId")
    protected String clientId;

    @JsonProperty("clientSecret")
    protected String clientSecret;

    @JsonProperty("connectionUrl")
    protected String connectionUrl;

    @JsonProperty("customizations")
    protected EducationSynchronizationCustomizations customizations;

    @JsonProperty("schoolsIds")
    protected List<String> schoolsIds;

    @JsonProperty("schoolsIds@nextLink")
    protected String schoolsIdsNextLink;

    @JsonProperty("schoolYear")
    protected String schoolYear;

    protected EducationPowerSchoolDataProvider() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationPowerSchoolDataProvider";
    }

    @Property(name="allowTeachersInMultipleSchools")
    @JsonIgnore
    public Optional<Boolean> getAllowTeachersInMultipleSchools() {
        return Optional.ofNullable(allowTeachersInMultipleSchools);
    }

    public EducationPowerSchoolDataProvider withAllowTeachersInMultipleSchools(Boolean allowTeachersInMultipleSchools) {
        EducationPowerSchoolDataProvider _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationPowerSchoolDataProvider");
        _x.allowTeachersInMultipleSchools = allowTeachersInMultipleSchools;
        return _x;
    }

    @Property(name="clientId")
    @JsonIgnore
    public Optional<String> getClientId() {
        return Optional.ofNullable(clientId);
    }

    public EducationPowerSchoolDataProvider withClientId(String clientId) {
        EducationPowerSchoolDataProvider _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationPowerSchoolDataProvider");
        _x.clientId = clientId;
        return _x;
    }

    @Property(name="clientSecret")
    @JsonIgnore
    public Optional<String> getClientSecret() {
        return Optional.ofNullable(clientSecret);
    }

    public EducationPowerSchoolDataProvider withClientSecret(String clientSecret) {
        EducationPowerSchoolDataProvider _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationPowerSchoolDataProvider");
        _x.clientSecret = clientSecret;
        return _x;
    }

    @Property(name="connectionUrl")
    @JsonIgnore
    public Optional<String> getConnectionUrl() {
        return Optional.ofNullable(connectionUrl);
    }

    public EducationPowerSchoolDataProvider withConnectionUrl(String connectionUrl) {
        EducationPowerSchoolDataProvider _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationPowerSchoolDataProvider");
        _x.connectionUrl = connectionUrl;
        return _x;
    }

    @Property(name="customizations")
    @JsonIgnore
    public Optional<EducationSynchronizationCustomizations> getCustomizations() {
        return Optional.ofNullable(customizations);
    }

    public EducationPowerSchoolDataProvider withCustomizations(EducationSynchronizationCustomizations customizations) {
        EducationPowerSchoolDataProvider _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationPowerSchoolDataProvider");
        _x.customizations = customizations;
        return _x;
    }

    @Property(name="schoolsIds")
    @JsonIgnore
    public CollectionPage<String> getSchoolsIds() {
        return new CollectionPage<String>(contextPath, String.class, this.schoolsIds, Optional.ofNullable(schoolsIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="schoolsIds")
    @JsonIgnore
    public CollectionPage<String> getSchoolsIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.schoolsIds, Optional.ofNullable(schoolsIdsNextLink), Collections.emptyList(), options);
    }

    @Property(name="schoolYear")
    @JsonIgnore
    public Optional<String> getSchoolYear() {
        return Optional.ofNullable(schoolYear);
    }

    public EducationPowerSchoolDataProvider withSchoolYear(String schoolYear) {
        EducationPowerSchoolDataProvider _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationPowerSchoolDataProvider");
        _x.schoolYear = schoolYear;
        return _x;
    }

    public EducationPowerSchoolDataProvider withUnmappedField(String name, Object value) {
        EducationPowerSchoolDataProvider _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationPowerSchoolDataProvider() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean allowTeachersInMultipleSchools;
        private String clientId;
        private String clientSecret;
        private String connectionUrl;
        private EducationSynchronizationCustomizations customizations;
        private List<String> schoolsIds;
        private String schoolsIdsNextLink;
        private String schoolYear;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder allowTeachersInMultipleSchools(Boolean allowTeachersInMultipleSchools) {
            this.allowTeachersInMultipleSchools = allowTeachersInMultipleSchools;
            this.changedFields = changedFields.add("allowTeachersInMultipleSchools");
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            this.changedFields = changedFields.add("clientId");
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            this.changedFields = changedFields.add("clientSecret");
            return this;
        }

        public Builder connectionUrl(String connectionUrl) {
            this.connectionUrl = connectionUrl;
            this.changedFields = changedFields.add("connectionUrl");
            return this;
        }

        public Builder customizations(EducationSynchronizationCustomizations customizations) {
            this.customizations = customizations;
            this.changedFields = changedFields.add("customizations");
            return this;
        }

        public Builder schoolsIds(List<String> schoolsIds) {
            this.schoolsIds = schoolsIds;
            this.changedFields = changedFields.add("schoolsIds");
            return this;
        }

        public Builder schoolsIds(String... schoolsIds) {
            return schoolsIds(Arrays.asList(schoolsIds));
        }

        public Builder schoolsIdsNextLink(String schoolsIdsNextLink) {
            this.schoolsIdsNextLink = schoolsIdsNextLink;
            this.changedFields = changedFields.add("schoolsIds");
            return this;
        }

        public Builder schoolYear(String schoolYear) {
            this.schoolYear = schoolYear;
            this.changedFields = changedFields.add("schoolYear");
            return this;
        }

        public EducationPowerSchoolDataProvider build() {
            EducationPowerSchoolDataProvider _x = new EducationPowerSchoolDataProvider();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.educationPowerSchoolDataProvider";
            _x.allowTeachersInMultipleSchools = allowTeachersInMultipleSchools;
            _x.clientId = clientId;
            _x.clientSecret = clientSecret;
            _x.connectionUrl = connectionUrl;
            _x.customizations = customizations;
            _x.schoolsIds = schoolsIds;
            _x.schoolsIdsNextLink = schoolsIdsNextLink;
            _x.schoolYear = schoolYear;
            return _x;
        }
    }

    private EducationPowerSchoolDataProvider _copy() {
        EducationPowerSchoolDataProvider _x = new EducationPowerSchoolDataProvider();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.allowTeachersInMultipleSchools = allowTeachersInMultipleSchools;
        _x.clientId = clientId;
        _x.clientSecret = clientSecret;
        _x.connectionUrl = connectionUrl;
        _x.customizations = customizations;
        _x.schoolsIds = schoolsIds;
        _x.schoolYear = schoolYear;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationPowerSchoolDataProvider[");
        b.append("allowTeachersInMultipleSchools=");
        b.append(this.allowTeachersInMultipleSchools);
        b.append(", ");
        b.append("clientId=");
        b.append(this.clientId);
        b.append(", ");
        b.append("clientSecret=");
        b.append(this.clientSecret);
        b.append(", ");
        b.append("connectionUrl=");
        b.append(this.connectionUrl);
        b.append(", ");
        b.append("customizations=");
        b.append(this.customizations);
        b.append(", ");
        b.append("schoolsIds=");
        b.append(this.schoolsIds);
        b.append(", ");
        b.append("schoolYear=");
        b.append(this.schoolYear);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
