package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "connectionSettings", 
    "connectionUrl", 
    "customizations", 
    "providerName", 
    "schoolsIds", 
    "termIds"})
@JsonInclude(Include.NON_NULL)
public class EducationOneRosterApiDataProvider extends EducationSynchronizationDataProvider implements ODataType {

    @JsonProperty("connectionSettings")
    protected EducationSynchronizationConnectionSettings connectionSettings;

    @JsonProperty("connectionUrl")
    protected String connectionUrl;

    @JsonProperty("customizations")
    protected EducationSynchronizationCustomizations customizations;

    @JsonProperty("providerName")
    protected String providerName;

    @JsonProperty("schoolsIds")
    protected List<String> schoolsIds;

    @JsonProperty("schoolsIds@nextLink")
    protected String schoolsIdsNextLink;

    @JsonProperty("termIds")
    protected List<String> termIds;

    @JsonProperty("termIds@nextLink")
    protected String termIdsNextLink;

    protected EducationOneRosterApiDataProvider() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationOneRosterApiDataProvider";
    }

    @Property(name="connectionSettings")
    @JsonIgnore
    public Optional<EducationSynchronizationConnectionSettings> getConnectionSettings() {
        return Optional.ofNullable(connectionSettings);
    }

    public EducationOneRosterApiDataProvider withConnectionSettings(EducationSynchronizationConnectionSettings connectionSettings) {
        EducationOneRosterApiDataProvider _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationOneRosterApiDataProvider");
        _x.connectionSettings = connectionSettings;
        return _x;
    }

    @Property(name="connectionUrl")
    @JsonIgnore
    public Optional<String> getConnectionUrl() {
        return Optional.ofNullable(connectionUrl);
    }

    public EducationOneRosterApiDataProvider withConnectionUrl(String connectionUrl) {
        EducationOneRosterApiDataProvider _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationOneRosterApiDataProvider");
        _x.connectionUrl = connectionUrl;
        return _x;
    }

    @Property(name="customizations")
    @JsonIgnore
    public Optional<EducationSynchronizationCustomizations> getCustomizations() {
        return Optional.ofNullable(customizations);
    }

    public EducationOneRosterApiDataProvider withCustomizations(EducationSynchronizationCustomizations customizations) {
        EducationOneRosterApiDataProvider _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationOneRosterApiDataProvider");
        _x.customizations = customizations;
        return _x;
    }

    @Property(name="providerName")
    @JsonIgnore
    public Optional<String> getProviderName() {
        return Optional.ofNullable(providerName);
    }

    public EducationOneRosterApiDataProvider withProviderName(String providerName) {
        EducationOneRosterApiDataProvider _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationOneRosterApiDataProvider");
        _x.providerName = providerName;
        return _x;
    }

    @Property(name="schoolsIds")
    @JsonIgnore
    public CollectionPage<String> getSchoolsIds() {
        return new CollectionPage<String>(contextPath, String.class, this.schoolsIds, Optional.ofNullable(schoolsIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="schoolsIds")
    @JsonIgnore
    public CollectionPage<String> getSchoolsIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.schoolsIds, Optional.ofNullable(schoolsIdsNextLink), Collections.emptyList(), options);
    }

    @Property(name="termIds")
    @JsonIgnore
    public CollectionPage<String> getTermIds() {
        return new CollectionPage<String>(contextPath, String.class, this.termIds, Optional.ofNullable(termIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="termIds")
    @JsonIgnore
    public CollectionPage<String> getTermIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.termIds, Optional.ofNullable(termIdsNextLink), Collections.emptyList(), options);
    }

    public EducationOneRosterApiDataProvider withUnmappedField(String name, Object value) {
        EducationOneRosterApiDataProvider _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationOneRosterApiDataProvider() {
        return new Builder();
    }

    public static final class Builder {
        private EducationSynchronizationConnectionSettings connectionSettings;
        private String connectionUrl;
        private EducationSynchronizationCustomizations customizations;
        private String providerName;
        private List<String> schoolsIds;
        private String schoolsIdsNextLink;
        private List<String> termIds;
        private String termIdsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder connectionSettings(EducationSynchronizationConnectionSettings connectionSettings) {
            this.connectionSettings = connectionSettings;
            this.changedFields = changedFields.add("connectionSettings");
            return this;
        }

        public Builder connectionUrl(String connectionUrl) {
            this.connectionUrl = connectionUrl;
            this.changedFields = changedFields.add("connectionUrl");
            return this;
        }

        public Builder customizations(EducationSynchronizationCustomizations customizations) {
            this.customizations = customizations;
            this.changedFields = changedFields.add("customizations");
            return this;
        }

        public Builder providerName(String providerName) {
            this.providerName = providerName;
            this.changedFields = changedFields.add("providerName");
            return this;
        }

        public Builder schoolsIds(List<String> schoolsIds) {
            this.schoolsIds = schoolsIds;
            this.changedFields = changedFields.add("schoolsIds");
            return this;
        }

        public Builder schoolsIds(String... schoolsIds) {
            return schoolsIds(Arrays.asList(schoolsIds));
        }

        public Builder schoolsIdsNextLink(String schoolsIdsNextLink) {
            this.schoolsIdsNextLink = schoolsIdsNextLink;
            this.changedFields = changedFields.add("schoolsIds");
            return this;
        }

        public Builder termIds(List<String> termIds) {
            this.termIds = termIds;
            this.changedFields = changedFields.add("termIds");
            return this;
        }

        public Builder termIds(String... termIds) {
            return termIds(Arrays.asList(termIds));
        }

        public Builder termIdsNextLink(String termIdsNextLink) {
            this.termIdsNextLink = termIdsNextLink;
            this.changedFields = changedFields.add("termIds");
            return this;
        }

        public EducationOneRosterApiDataProvider build() {
            EducationOneRosterApiDataProvider _x = new EducationOneRosterApiDataProvider();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.educationOneRosterApiDataProvider";
            _x.connectionSettings = connectionSettings;
            _x.connectionUrl = connectionUrl;
            _x.customizations = customizations;
            _x.providerName = providerName;
            _x.schoolsIds = schoolsIds;
            _x.schoolsIdsNextLink = schoolsIdsNextLink;
            _x.termIds = termIds;
            _x.termIdsNextLink = termIdsNextLink;
            return _x;
        }
    }

    private EducationOneRosterApiDataProvider _copy() {
        EducationOneRosterApiDataProvider _x = new EducationOneRosterApiDataProvider();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.connectionSettings = connectionSettings;
        _x.connectionUrl = connectionUrl;
        _x.customizations = customizations;
        _x.providerName = providerName;
        _x.schoolsIds = schoolsIds;
        _x.termIds = termIds;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationOneRosterApiDataProvider[");
        b.append("connectionSettings=");
        b.append(this.connectionSettings);
        b.append(", ");
        b.append("connectionUrl=");
        b.append(this.connectionUrl);
        b.append(", ");
        b.append("customizations=");
        b.append(this.customizations);
        b.append(", ");
        b.append("providerName=");
        b.append(this.providerName);
        b.append(", ");
        b.append("schoolsIds=");
        b.append(this.schoolsIds);
        b.append(", ");
        b.append("termIds=");
        b.append(this.termIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
