package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "matchingOptions"})
@JsonInclude(Include.NON_NULL)
public class EducationIdentityMatchingConfiguration extends EducationIdentitySynchronizationConfiguration implements ODataType {

    @JsonProperty("matchingOptions")
    protected List<EducationIdentityMatchingOptions> matchingOptions;

    @JsonProperty("matchingOptions@nextLink")
    protected String matchingOptionsNextLink;

    protected EducationIdentityMatchingConfiguration() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationIdentityMatchingConfiguration";
    }

    @Property(name="matchingOptions")
    @JsonIgnore
    public CollectionPage<EducationIdentityMatchingOptions> getMatchingOptions() {
        return new CollectionPage<EducationIdentityMatchingOptions>(contextPath, EducationIdentityMatchingOptions.class, this.matchingOptions, Optional.ofNullable(matchingOptionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="matchingOptions")
    @JsonIgnore
    public CollectionPage<EducationIdentityMatchingOptions> getMatchingOptions(HttpRequestOptions options) {
        return new CollectionPage<EducationIdentityMatchingOptions>(contextPath, EducationIdentityMatchingOptions.class, this.matchingOptions, Optional.ofNullable(matchingOptionsNextLink), Collections.emptyList(), options);
    }

    public EducationIdentityMatchingConfiguration withUnmappedField(String name, Object value) {
        EducationIdentityMatchingConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationIdentityMatchingConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private List<EducationIdentityMatchingOptions> matchingOptions;
        private String matchingOptionsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder matchingOptions(List<EducationIdentityMatchingOptions> matchingOptions) {
            this.matchingOptions = matchingOptions;
            this.changedFields = changedFields.add("matchingOptions");
            return this;
        }

        public Builder matchingOptions(EducationIdentityMatchingOptions... matchingOptions) {
            return matchingOptions(Arrays.asList(matchingOptions));
        }

        public Builder matchingOptionsNextLink(String matchingOptionsNextLink) {
            this.matchingOptionsNextLink = matchingOptionsNextLink;
            this.changedFields = changedFields.add("matchingOptions");
            return this;
        }

        public EducationIdentityMatchingConfiguration build() {
            EducationIdentityMatchingConfiguration _x = new EducationIdentityMatchingConfiguration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.educationIdentityMatchingConfiguration";
            _x.matchingOptions = matchingOptions;
            _x.matchingOptionsNextLink = matchingOptionsNextLink;
            return _x;
        }
    }

    private EducationIdentityMatchingConfiguration _copy() {
        EducationIdentityMatchingConfiguration _x = new EducationIdentityMatchingConfiguration();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.matchingOptions = matchingOptions;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationIdentityMatchingConfiguration[");
        b.append("matchingOptions=");
        b.append(this.matchingOptions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
