package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.EdgeSearchEngineType;


/**
 * <i>“Allows IT admins to set a predefined default search engine for MDM-Controlled
 * devices.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "edgeSearchEngineType"})
@JsonInclude(Include.NON_NULL)
public class EdgeSearchEngine extends EdgeSearchEngineBase implements ODataType {

    @JsonProperty("edgeSearchEngineType")
    protected EdgeSearchEngineType edgeSearchEngineType;

    protected EdgeSearchEngine() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.edgeSearchEngine";
    }

    /**
     * <i>“Allows IT admins to set a predefined default search engine for MDM-Controlled
     * devices.”</i>
     * 
     * @return property edgeSearchEngineType
     */
    @Property(name="edgeSearchEngineType")
    @JsonIgnore
    public Optional<EdgeSearchEngineType> getEdgeSearchEngineType() {
        return Optional.ofNullable(edgeSearchEngineType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeSearchEngineType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Allows IT admins to set a predefined default search engine for MDM-Controlled
     * devices.”</i>
     * 
     * @param edgeSearchEngineType
     *            new value of {@code edgeSearchEngineType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeSearchEngineType} field changed
     */
    public EdgeSearchEngine withEdgeSearchEngineType(EdgeSearchEngineType edgeSearchEngineType) {
        EdgeSearchEngine _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.edgeSearchEngine");
        _x.edgeSearchEngineType = edgeSearchEngineType;
        return _x;
    }

    public EdgeSearchEngine withUnmappedField(String name, Object value) {
        EdgeSearchEngine _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEdgeSearchEngine() {
        return new Builder();
    }

    public static final class Builder {
        private EdgeSearchEngineType edgeSearchEngineType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Allows IT admins to set a predefined default search engine for MDM-Controlled
         * devices.”</i>
         * 
         * @param edgeSearchEngineType
         *            value of {@code edgeSearchEngineType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeSearchEngineType(EdgeSearchEngineType edgeSearchEngineType) {
            this.edgeSearchEngineType = edgeSearchEngineType;
            this.changedFields = changedFields.add("edgeSearchEngineType");
            return this;
        }

        public EdgeSearchEngine build() {
            EdgeSearchEngine _x = new EdgeSearchEngine();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.edgeSearchEngine";
            _x.edgeSearchEngineType = edgeSearchEngineType;
            return _x;
        }
    }

    private EdgeSearchEngine _copy() {
        EdgeSearchEngine _x = new EdgeSearchEngine();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.edgeSearchEngineType = edgeSearchEngineType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EdgeSearchEngine[");
        b.append("edgeSearchEngineType=");
        b.append(this.edgeSearchEngineType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
