package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Show the home button; clicking the home button loads a specific URL.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "homeButtonCustomURL"})
@JsonInclude(Include.NON_NULL)
public class EdgeHomeButtonOpensCustomURL extends EdgeHomeButtonConfiguration implements ODataType {

    @JsonProperty("homeButtonCustomURL")
    protected String homeButtonCustomURL;

    protected EdgeHomeButtonOpensCustomURL() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.edgeHomeButtonOpensCustomURL";
    }

    /**
     * <i>“The specific URL to load.”</i>
     * 
     * @return property homeButtonCustomURL
     */
    @Property(name="homeButtonCustomURL")
    @JsonIgnore
    public Optional<String> getHomeButtonCustomURL() {
        return Optional.ofNullable(homeButtonCustomURL);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * homeButtonCustomURL} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The specific URL to load.”</i>
     * 
     * @param homeButtonCustomURL
     *            new value of {@code homeButtonCustomURL} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code homeButtonCustomURL} field changed
     */
    public EdgeHomeButtonOpensCustomURL withHomeButtonCustomURL(String homeButtonCustomURL) {
        EdgeHomeButtonOpensCustomURL _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.edgeHomeButtonOpensCustomURL");
        _x.homeButtonCustomURL = homeButtonCustomURL;
        return _x;
    }

    public EdgeHomeButtonOpensCustomURL withUnmappedField(String name, Object value) {
        EdgeHomeButtonOpensCustomURL _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEdgeHomeButtonOpensCustomURL() {
        return new Builder();
    }

    public static final class Builder {
        private String homeButtonCustomURL;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The specific URL to load.”</i>
         * 
         * @param homeButtonCustomURL
         *            value of {@code homeButtonCustomURL} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder homeButtonCustomURL(String homeButtonCustomURL) {
            this.homeButtonCustomURL = homeButtonCustomURL;
            this.changedFields = changedFields.add("homeButtonCustomURL");
            return this;
        }

        public EdgeHomeButtonOpensCustomURL build() {
            EdgeHomeButtonOpensCustomURL _x = new EdgeHomeButtonOpensCustomURL();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.edgeHomeButtonOpensCustomURL";
            _x.homeButtonCustomURL = homeButtonCustomURL;
            return _x;
        }
    }

    private EdgeHomeButtonOpensCustomURL _copy() {
        EdgeHomeButtonOpensCustomURL _x = new EdgeHomeButtonOpensCustomURL();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.homeButtonCustomURL = homeButtonCustomURL;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EdgeHomeButtonOpensCustomURL[");
        b.append("homeButtonCustomURL=");
        b.append(this.homeButtonCustomURL);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
