package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "contentType", 
    "fileName", 
    "folderName"})
@JsonInclude(Include.NON_NULL)
public class DocumentSetContent implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("contentType")
    protected ContentTypeInfo contentType;

    @JsonProperty("fileName")
    protected String fileName;

    @JsonProperty("folderName")
    protected String folderName;

    protected DocumentSetContent() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.documentSetContent";
    }

    @Property(name="contentType")
    @JsonIgnore
    public Optional<ContentTypeInfo> getContentType() {
        return Optional.ofNullable(contentType);
    }

    public DocumentSetContent withContentType(ContentTypeInfo contentType) {
        DocumentSetContent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.documentSetContent");
        _x.contentType = contentType;
        return _x;
    }

    @Property(name="fileName")
    @JsonIgnore
    public Optional<String> getFileName() {
        return Optional.ofNullable(fileName);
    }

    public DocumentSetContent withFileName(String fileName) {
        DocumentSetContent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.documentSetContent");
        _x.fileName = fileName;
        return _x;
    }

    @Property(name="folderName")
    @JsonIgnore
    public Optional<String> getFolderName() {
        return Optional.ofNullable(folderName);
    }

    public DocumentSetContent withFolderName(String folderName) {
        DocumentSetContent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.documentSetContent");
        _x.folderName = folderName;
        return _x;
    }

    public DocumentSetContent withUnmappedField(String name, Object value) {
        DocumentSetContent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ContentTypeInfo contentType;
        private String fileName;
        private String folderName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder contentType(ContentTypeInfo contentType) {
            this.contentType = contentType;
            this.changedFields = changedFields.add("contentType");
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.changedFields = changedFields.add("fileName");
            return this;
        }

        public Builder folderName(String folderName) {
            this.folderName = folderName;
            this.changedFields = changedFields.add("folderName");
            return this;
        }

        public DocumentSetContent build() {
            DocumentSetContent _x = new DocumentSetContent();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.documentSetContent";
            _x.contentType = contentType;
            _x.fileName = fileName;
            _x.folderName = folderName;
            return _x;
        }
    }

    private DocumentSetContent _copy() {
        DocumentSetContent _x = new DocumentSetContent();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.contentType = contentType;
        _x.fileName = fileName;
        _x.folderName = folderName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DocumentSetContent[");
        b.append("contentType=");
        b.append(this.contentType);
        b.append(", ");
        b.append("fileName=");
        b.append(this.fileName);
        b.append(", ");
        b.append("folderName=");
        b.append(this.folderName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
