package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ColumnDefinition;

@JsonPropertyOrder({
    "@odata.type", 
    "allowedContentTypes", 
    "defaultContents", 
    "propagateWelcomePageChanges", 
    "shouldPrefixNameToFile", 
    "welcomePageUrl", 
    "sharedColumns", 
    "welcomePageColumns"})
@JsonInclude(Include.NON_NULL)
public class DocumentSet implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("allowedContentTypes")
    protected List<ContentTypeInfo> allowedContentTypes;

    @JsonProperty("allowedContentTypes@nextLink")
    protected String allowedContentTypesNextLink;

    @JsonProperty("defaultContents")
    protected List<DocumentSetContent> defaultContents;

    @JsonProperty("defaultContents@nextLink")
    protected String defaultContentsNextLink;

    @JsonProperty("propagateWelcomePageChanges")
    protected Boolean propagateWelcomePageChanges;

    @JsonProperty("shouldPrefixNameToFile")
    protected Boolean shouldPrefixNameToFile;

    @JsonProperty("welcomePageUrl")
    protected String welcomePageUrl;

    @JsonProperty("sharedColumns")
    protected List<ColumnDefinition> sharedColumns;

    @JsonProperty("welcomePageColumns")
    protected List<ColumnDefinition> welcomePageColumns;

    protected DocumentSet() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.documentSet";
    }

    @Property(name="allowedContentTypes")
    @JsonIgnore
    public CollectionPage<ContentTypeInfo> getAllowedContentTypes() {
        return new CollectionPage<ContentTypeInfo>(contextPath, ContentTypeInfo.class, this.allowedContentTypes, Optional.ofNullable(allowedContentTypesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="allowedContentTypes")
    @JsonIgnore
    public CollectionPage<ContentTypeInfo> getAllowedContentTypes(HttpRequestOptions options) {
        return new CollectionPage<ContentTypeInfo>(contextPath, ContentTypeInfo.class, this.allowedContentTypes, Optional.ofNullable(allowedContentTypesNextLink), Collections.emptyList(), options);
    }

    @Property(name="defaultContents")
    @JsonIgnore
    public CollectionPage<DocumentSetContent> getDefaultContents() {
        return new CollectionPage<DocumentSetContent>(contextPath, DocumentSetContent.class, this.defaultContents, Optional.ofNullable(defaultContentsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="defaultContents")
    @JsonIgnore
    public CollectionPage<DocumentSetContent> getDefaultContents(HttpRequestOptions options) {
        return new CollectionPage<DocumentSetContent>(contextPath, DocumentSetContent.class, this.defaultContents, Optional.ofNullable(defaultContentsNextLink), Collections.emptyList(), options);
    }

    @Property(name="propagateWelcomePageChanges")
    @JsonIgnore
    public Optional<Boolean> getPropagateWelcomePageChanges() {
        return Optional.ofNullable(propagateWelcomePageChanges);
    }

    public DocumentSet withPropagateWelcomePageChanges(Boolean propagateWelcomePageChanges) {
        DocumentSet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.documentSet");
        _x.propagateWelcomePageChanges = propagateWelcomePageChanges;
        return _x;
    }

    @Property(name="shouldPrefixNameToFile")
    @JsonIgnore
    public Optional<Boolean> getShouldPrefixNameToFile() {
        return Optional.ofNullable(shouldPrefixNameToFile);
    }

    public DocumentSet withShouldPrefixNameToFile(Boolean shouldPrefixNameToFile) {
        DocumentSet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.documentSet");
        _x.shouldPrefixNameToFile = shouldPrefixNameToFile;
        return _x;
    }

    @Property(name="welcomePageUrl")
    @JsonIgnore
    public Optional<String> getWelcomePageUrl() {
        return Optional.ofNullable(welcomePageUrl);
    }

    public DocumentSet withWelcomePageUrl(String welcomePageUrl) {
        DocumentSet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.documentSet");
        _x.welcomePageUrl = welcomePageUrl;
        return _x;
    }

    public DocumentSet withUnmappedField(String name, Object value) {
        DocumentSet _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<ContentTypeInfo> allowedContentTypes;
        private String allowedContentTypesNextLink;
        private List<DocumentSetContent> defaultContents;
        private String defaultContentsNextLink;
        private Boolean propagateWelcomePageChanges;
        private Boolean shouldPrefixNameToFile;
        private String welcomePageUrl;
        private List<ColumnDefinition> sharedColumns;
        private List<ColumnDefinition> welcomePageColumns;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder allowedContentTypes(List<ContentTypeInfo> allowedContentTypes) {
            this.allowedContentTypes = allowedContentTypes;
            this.changedFields = changedFields.add("allowedContentTypes");
            return this;
        }

        public Builder allowedContentTypes(ContentTypeInfo... allowedContentTypes) {
            return allowedContentTypes(Arrays.asList(allowedContentTypes));
        }

        public Builder allowedContentTypesNextLink(String allowedContentTypesNextLink) {
            this.allowedContentTypesNextLink = allowedContentTypesNextLink;
            this.changedFields = changedFields.add("allowedContentTypes");
            return this;
        }

        public Builder defaultContents(List<DocumentSetContent> defaultContents) {
            this.defaultContents = defaultContents;
            this.changedFields = changedFields.add("defaultContents");
            return this;
        }

        public Builder defaultContents(DocumentSetContent... defaultContents) {
            return defaultContents(Arrays.asList(defaultContents));
        }

        public Builder defaultContentsNextLink(String defaultContentsNextLink) {
            this.defaultContentsNextLink = defaultContentsNextLink;
            this.changedFields = changedFields.add("defaultContents");
            return this;
        }

        public Builder propagateWelcomePageChanges(Boolean propagateWelcomePageChanges) {
            this.propagateWelcomePageChanges = propagateWelcomePageChanges;
            this.changedFields = changedFields.add("propagateWelcomePageChanges");
            return this;
        }

        public Builder shouldPrefixNameToFile(Boolean shouldPrefixNameToFile) {
            this.shouldPrefixNameToFile = shouldPrefixNameToFile;
            this.changedFields = changedFields.add("shouldPrefixNameToFile");
            return this;
        }

        public Builder welcomePageUrl(String welcomePageUrl) {
            this.welcomePageUrl = welcomePageUrl;
            this.changedFields = changedFields.add("welcomePageUrl");
            return this;
        }

        public Builder sharedColumns(List<ColumnDefinition> sharedColumns) {
            this.sharedColumns = sharedColumns;
            this.changedFields = changedFields.add("sharedColumns");
            return this;
        }

        public Builder sharedColumns(ColumnDefinition... sharedColumns) {
            return sharedColumns(Arrays.asList(sharedColumns));
        }

        public Builder welcomePageColumns(List<ColumnDefinition> welcomePageColumns) {
            this.welcomePageColumns = welcomePageColumns;
            this.changedFields = changedFields.add("welcomePageColumns");
            return this;
        }

        public Builder welcomePageColumns(ColumnDefinition... welcomePageColumns) {
            return welcomePageColumns(Arrays.asList(welcomePageColumns));
        }

        public DocumentSet build() {
            DocumentSet _x = new DocumentSet();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.documentSet";
            _x.allowedContentTypes = allowedContentTypes;
            _x.allowedContentTypesNextLink = allowedContentTypesNextLink;
            _x.defaultContents = defaultContents;
            _x.defaultContentsNextLink = defaultContentsNextLink;
            _x.propagateWelcomePageChanges = propagateWelcomePageChanges;
            _x.shouldPrefixNameToFile = shouldPrefixNameToFile;
            _x.welcomePageUrl = welcomePageUrl;
            _x.sharedColumns = sharedColumns;
            _x.welcomePageColumns = welcomePageColumns;
            return _x;
        }
    }

    private DocumentSet _copy() {
        DocumentSet _x = new DocumentSet();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.allowedContentTypes = allowedContentTypes;
        _x.defaultContents = defaultContents;
        _x.propagateWelcomePageChanges = propagateWelcomePageChanges;
        _x.shouldPrefixNameToFile = shouldPrefixNameToFile;
        _x.welcomePageUrl = welcomePageUrl;
        _x.sharedColumns = sharedColumns;
        _x.welcomePageColumns = welcomePageColumns;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DocumentSet[");
        b.append("allowedContentTypes=");
        b.append(this.allowedContentTypes);
        b.append(", ");
        b.append("defaultContents=");
        b.append(this.defaultContents);
        b.append(", ");
        b.append("propagateWelcomePageChanges=");
        b.append(this.propagateWelcomePageChanges);
        b.append(", ");
        b.append("shouldPrefixNameToFile=");
        b.append(this.shouldPrefixNameToFile);
        b.append(", ");
        b.append("welcomePageUrl=");
        b.append(this.welcomePageUrl);
        b.append(", ");
        b.append("sharedColumns=");
        b.append(this.sharedColumns);
        b.append(", ");
        b.append("welcomePageColumns=");
        b.append(this.welcomePageColumns);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
