package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "classificationAttributes", 
    "confidence", 
    "count", 
    "id"})
@JsonInclude(Include.NON_NULL)
public class DiscoveredSensitiveType implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("classificationAttributes")
    protected List<ClassificationAttribute> classificationAttributes;

    @JsonProperty("classificationAttributes@nextLink")
    protected String classificationAttributesNextLink;

    @JsonProperty("confidence")
    protected Integer confidence;

    @JsonProperty("count")
    protected Integer count;

    @JsonProperty("id")
    protected UUID id;

    protected DiscoveredSensitiveType() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.discoveredSensitiveType";
    }

    @Property(name="classificationAttributes")
    @JsonIgnore
    public CollectionPage<ClassificationAttribute> getClassificationAttributes() {
        return new CollectionPage<ClassificationAttribute>(contextPath, ClassificationAttribute.class, this.classificationAttributes, Optional.ofNullable(classificationAttributesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="classificationAttributes")
    @JsonIgnore
    public CollectionPage<ClassificationAttribute> getClassificationAttributes(HttpRequestOptions options) {
        return new CollectionPage<ClassificationAttribute>(contextPath, ClassificationAttribute.class, this.classificationAttributes, Optional.ofNullable(classificationAttributesNextLink), Collections.emptyList(), options);
    }

    @Property(name="confidence")
    @JsonIgnore
    public Optional<Integer> getConfidence() {
        return Optional.ofNullable(confidence);
    }

    public DiscoveredSensitiveType withConfidence(Integer confidence) {
        DiscoveredSensitiveType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.discoveredSensitiveType");
        _x.confidence = confidence;
        return _x;
    }

    @Property(name="count")
    @JsonIgnore
    public Optional<Integer> getCount() {
        return Optional.ofNullable(count);
    }

    public DiscoveredSensitiveType withCount(Integer count) {
        DiscoveredSensitiveType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.discoveredSensitiveType");
        _x.count = count;
        return _x;
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<UUID> getId() {
        return Optional.ofNullable(id);
    }

    public DiscoveredSensitiveType withId(UUID id) {
        DiscoveredSensitiveType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.discoveredSensitiveType");
        _x.id = id;
        return _x;
    }

    public DiscoveredSensitiveType withUnmappedField(String name, Object value) {
        DiscoveredSensitiveType _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<ClassificationAttribute> classificationAttributes;
        private String classificationAttributesNextLink;
        private Integer confidence;
        private Integer count;
        private UUID id;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder classificationAttributes(List<ClassificationAttribute> classificationAttributes) {
            this.classificationAttributes = classificationAttributes;
            this.changedFields = changedFields.add("classificationAttributes");
            return this;
        }

        public Builder classificationAttributes(ClassificationAttribute... classificationAttributes) {
            return classificationAttributes(Arrays.asList(classificationAttributes));
        }

        public Builder classificationAttributesNextLink(String classificationAttributesNextLink) {
            this.classificationAttributesNextLink = classificationAttributesNextLink;
            this.changedFields = changedFields.add("classificationAttributes");
            return this;
        }

        public Builder confidence(Integer confidence) {
            this.confidence = confidence;
            this.changedFields = changedFields.add("confidence");
            return this;
        }

        public Builder count(Integer count) {
            this.count = count;
            this.changedFields = changedFields.add("count");
            return this;
        }

        public Builder id(UUID id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public DiscoveredSensitiveType build() {
            DiscoveredSensitiveType _x = new DiscoveredSensitiveType();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.discoveredSensitiveType";
            _x.classificationAttributes = classificationAttributes;
            _x.classificationAttributesNextLink = classificationAttributesNextLink;
            _x.confidence = confidence;
            _x.count = count;
            _x.id = id;
            return _x;
        }
    }

    private DiscoveredSensitiveType _copy() {
        DiscoveredSensitiveType _x = new DiscoveredSensitiveType();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.classificationAttributes = classificationAttributes;
        _x.confidence = confidence;
        _x.count = count;
        _x.id = id;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DiscoveredSensitiveType[");
        b.append("classificationAttributes=");
        b.append(this.classificationAttributes);
        b.append(", ");
        b.append("confidence=");
        b.append(this.confidence);
        b.append(", ");
        b.append("count=");
        b.append(this.count);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
