package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Represents information for a local user or group used for user rights setting.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "name", 
    "securityIdentifier"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementUserRightsLocalUserOrGroup implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("securityIdentifier")
    protected String securityIdentifier;

    protected DeviceManagementUserRightsLocalUserOrGroup() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementUserRightsLocalUserOrGroup";
    }

    /**
     * <i>“Admin’s description of this local user or group.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Admin’s description of this local user or group.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public DeviceManagementUserRightsLocalUserOrGroup withDescription(String description) {
        DeviceManagementUserRightsLocalUserOrGroup _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementUserRightsLocalUserOrGroup");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“The name of this local user or group.”</i>
     * 
     * @return property name
     */
    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code name} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The name of this local user or group.”</i>
     * 
     * @param name
     *            new value of {@code name} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code name} field changed
     */
    public DeviceManagementUserRightsLocalUserOrGroup withName(String name) {
        DeviceManagementUserRightsLocalUserOrGroup _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementUserRightsLocalUserOrGroup");
        _x.name = name;
        return _x;
    }

    /**
     * <i>“The security identifier of this local user or group (e.g. *S-1-5-32-544).”</i>
     * 
     * @return property securityIdentifier
     */
    @Property(name="securityIdentifier")
    @JsonIgnore
    public Optional<String> getSecurityIdentifier() {
        return Optional.ofNullable(securityIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * securityIdentifier} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The security identifier of this local user or group (e.g. *S-1-5-32-544).”</i>
     * 
     * @param securityIdentifier
     *            new value of {@code securityIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code securityIdentifier} field changed
     */
    public DeviceManagementUserRightsLocalUserOrGroup withSecurityIdentifier(String securityIdentifier) {
        DeviceManagementUserRightsLocalUserOrGroup _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementUserRightsLocalUserOrGroup");
        _x.securityIdentifier = securityIdentifier;
        return _x;
    }

    public DeviceManagementUserRightsLocalUserOrGroup withUnmappedField(String name, Object value) {
        DeviceManagementUserRightsLocalUserOrGroup _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String description;
        private String name;
        private String securityIdentifier;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Admin’s description of this local user or group.”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“The name of this local user or group.”</i>
         * 
         * @param name
         *            value of {@code name} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        /**
         * <i>“The security identifier of this local user or group (e.g. *S-1-5-32-544).”</i>
         * 
         * @param securityIdentifier
         *            value of {@code securityIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder securityIdentifier(String securityIdentifier) {
            this.securityIdentifier = securityIdentifier;
            this.changedFields = changedFields.add("securityIdentifier");
            return this;
        }

        public DeviceManagementUserRightsLocalUserOrGroup build() {
            DeviceManagementUserRightsLocalUserOrGroup _x = new DeviceManagementUserRightsLocalUserOrGroup();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementUserRightsLocalUserOrGroup";
            _x.description = description;
            _x.name = name;
            _x.securityIdentifier = securityIdentifier;
            return _x;
        }
    }

    private DeviceManagementUserRightsLocalUserOrGroup _copy() {
        DeviceManagementUserRightsLocalUserOrGroup _x = new DeviceManagementUserRightsLocalUserOrGroup();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.description = description;
        _x.name = name;
        _x.securityIdentifier = securityIdentifier;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementUserRightsLocalUserOrGroup[");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("securityIdentifier=");
        b.append(this.securityIdentifier);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
