package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Constraint that enforces the enrollment types applied to a setting”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "enrollmentTypes"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementSettingEnrollmentTypeConstraint extends DeviceManagementConstraint implements ODataType {

    @JsonProperty("enrollmentTypes")
    protected List<String> enrollmentTypes;

    @JsonProperty("enrollmentTypes@nextLink")
    protected String enrollmentTypesNextLink;

    protected DeviceManagementSettingEnrollmentTypeConstraint() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementSettingEnrollmentTypeConstraint";
    }

    /**
     * <i>“List of enrollment types”</i>
     * 
     * @return property enrollmentTypes
     */
    @Property(name="enrollmentTypes")
    @JsonIgnore
    public CollectionPage<String> getEnrollmentTypes() {
        return new CollectionPage<String>(contextPath, String.class, this.enrollmentTypes, Optional.ofNullable(enrollmentTypesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of enrollment types”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property enrollmentTypes
     */
    @Property(name="enrollmentTypes")
    @JsonIgnore
    public CollectionPage<String> getEnrollmentTypes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.enrollmentTypes, Optional.ofNullable(enrollmentTypesNextLink), Collections.emptyList(), options);
    }

    public DeviceManagementSettingEnrollmentTypeConstraint withUnmappedField(String name, Object value) {
        DeviceManagementSettingEnrollmentTypeConstraint _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementSettingEnrollmentTypeConstraint() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> enrollmentTypes;
        private String enrollmentTypesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“List of enrollment types”</i>
         * 
         * @param enrollmentTypes
         *            value of {@code enrollmentTypes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enrollmentTypes(List<String> enrollmentTypes) {
            this.enrollmentTypes = enrollmentTypes;
            this.changedFields = changedFields.add("enrollmentTypes");
            return this;
        }

        /**
         * <i>“List of enrollment types”</i>
         * 
         * @param enrollmentTypes
         *            value of {@code enrollmentTypes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enrollmentTypes(String... enrollmentTypes) {
            return enrollmentTypes(Arrays.asList(enrollmentTypes));
        }

        /**
         * <i>“List of enrollment types”</i>
         * 
         * @param enrollmentTypesNextLink
         *            value of {@code enrollmentTypes@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enrollmentTypesNextLink(String enrollmentTypesNextLink) {
            this.enrollmentTypesNextLink = enrollmentTypesNextLink;
            this.changedFields = changedFields.add("enrollmentTypes");
            return this;
        }

        public DeviceManagementSettingEnrollmentTypeConstraint build() {
            DeviceManagementSettingEnrollmentTypeConstraint _x = new DeviceManagementSettingEnrollmentTypeConstraint();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementSettingEnrollmentTypeConstraint";
            _x.enrollmentTypes = enrollmentTypes;
            _x.enrollmentTypesNextLink = enrollmentTypesNextLink;
            return _x;
        }
    }

    private DeviceManagementSettingEnrollmentTypeConstraint _copy() {
        DeviceManagementSettingEnrollmentTypeConstraint _x = new DeviceManagementSettingEnrollmentTypeConstraint();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.enrollmentTypes = enrollmentTypes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementSettingEnrollmentTypeConstraint[");
        b.append("enrollmentTypes=");
        b.append(this.enrollmentTypes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
