package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Constraint that enforces the setting value is from a permitted set of strings”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "values"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementEnumConstraint extends DeviceManagementConstraint implements ODataType {

    @JsonProperty("values")
    protected List<DeviceManagementEnumValue> values;

    @JsonProperty("values@nextLink")
    protected String valuesNextLink;

    protected DeviceManagementEnumConstraint() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementEnumConstraint";
    }

    /**
     * <i>“List of valid values for this string”</i>
     * 
     * @return property values
     */
    @Property(name="values")
    @JsonIgnore
    public CollectionPage<DeviceManagementEnumValue> getValues() {
        return new CollectionPage<DeviceManagementEnumValue>(contextPath, DeviceManagementEnumValue.class, this.values, Optional.ofNullable(valuesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of valid values for this string”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property values
     */
    @Property(name="values")
    @JsonIgnore
    public CollectionPage<DeviceManagementEnumValue> getValues(HttpRequestOptions options) {
        return new CollectionPage<DeviceManagementEnumValue>(contextPath, DeviceManagementEnumValue.class, this.values, Optional.ofNullable(valuesNextLink), Collections.emptyList(), options);
    }

    public DeviceManagementEnumConstraint withUnmappedField(String name, Object value) {
        DeviceManagementEnumConstraint _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementEnumConstraint() {
        return new Builder();
    }

    public static final class Builder {
        private List<DeviceManagementEnumValue> values;
        private String valuesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“List of valid values for this string”</i>
         * 
         * @param values
         *            value of {@code values} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder values(List<DeviceManagementEnumValue> values) {
            this.values = values;
            this.changedFields = changedFields.add("values");
            return this;
        }

        /**
         * <i>“List of valid values for this string”</i>
         * 
         * @param values
         *            value of {@code values} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder values(DeviceManagementEnumValue... values) {
            return values(Arrays.asList(values));
        }

        /**
         * <i>“List of valid values for this string”</i>
         * 
         * @param valuesNextLink
         *            value of {@code values@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder valuesNextLink(String valuesNextLink) {
            this.valuesNextLink = valuesNextLink;
            this.changedFields = changedFields.add("values");
            return this;
        }

        public DeviceManagementEnumConstraint build() {
            DeviceManagementEnumConstraint _x = new DeviceManagementEnumConstraint();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementEnumConstraint";
            _x.values = values;
            _x.valuesNextLink = valuesNextLink;
            return _x;
        }
    }

    private DeviceManagementEnumConstraint _copy() {
        DeviceManagementEnumConstraint _x = new DeviceManagementEnumConstraint();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.values = values;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementEnumConstraint[");
        b.append("values=");
        b.append(this.values);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
