package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceManagementConfigurationStringFormat;


/**
 * <i>“String constraints”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "format", 
    "inputValidationSchema", 
    "isSecret", 
    "maximumLength", 
    "minimumLength"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationStringSettingValueDefinition extends DeviceManagementConfigurationSettingValueDefinition implements ODataType {

    @JsonProperty("format")
    protected DeviceManagementConfigurationStringFormat format;

    @JsonProperty("inputValidationSchema")
    protected String inputValidationSchema;

    @JsonProperty("isSecret")
    protected Boolean isSecret;

    @JsonProperty("maximumLength")
    protected Long maximumLength;

    @JsonProperty("minimumLength")
    protected Long minimumLength;

    protected DeviceManagementConfigurationStringSettingValueDefinition() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationStringSettingValueDefinition";
    }

    /**
     * <i>“Pre-defined format of the string”</i>
     * 
     * @return property format
     */
    @Property(name="format")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationStringFormat> getFormat() {
        return Optional.ofNullable(format);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code format} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Pre-defined format of the string”</i>
     * 
     * @param format
     *            new value of {@code format} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code format} field changed
     */
    public DeviceManagementConfigurationStringSettingValueDefinition withFormat(DeviceManagementConfigurationStringFormat format) {
        DeviceManagementConfigurationStringSettingValueDefinition _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationStringSettingValueDefinition");
        _x.format = format;
        return _x;
    }

    /**
     * <i>“Regular expression or any xml or json schema that the input string should match”</i>
     * 
     * @return property inputValidationSchema
     */
    @Property(name="inputValidationSchema")
    @JsonIgnore
    public Optional<String> getInputValidationSchema() {
        return Optional.ofNullable(inputValidationSchema);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * inputValidationSchema} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Regular expression or any xml or json schema that the input string should match”</i>
     * 
     * @param inputValidationSchema
     *            new value of {@code inputValidationSchema} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code inputValidationSchema} field changed
     */
    public DeviceManagementConfigurationStringSettingValueDefinition withInputValidationSchema(String inputValidationSchema) {
        DeviceManagementConfigurationStringSettingValueDefinition _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationStringSettingValueDefinition");
        _x.inputValidationSchema = inputValidationSchema;
        return _x;
    }

    /**
     * <i>“Specifies whether the setting needs to be treated as a secret. Settings marked
     * as yes will be encrypted in transit and at rest and will be displayed as
     * asterisks when represented in the UX.”</i>
     * 
     * @return property isSecret
     */
    @Property(name="isSecret")
    @JsonIgnore
    public Optional<Boolean> getIsSecret() {
        return Optional.ofNullable(isSecret);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isSecret} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Specifies whether the setting needs to be treated as a secret. Settings marked
     * as yes will be encrypted in transit and at rest and will be displayed as
     * asterisks when represented in the UX.”</i>
     * 
     * @param isSecret
     *            new value of {@code isSecret} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isSecret} field changed
     */
    public DeviceManagementConfigurationStringSettingValueDefinition withIsSecret(Boolean isSecret) {
        DeviceManagementConfigurationStringSettingValueDefinition _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationStringSettingValueDefinition");
        _x.isSecret = isSecret;
        return _x;
    }

    /**
     * <i>“Maximum length of string. Valid values 0 to 87516”</i>
     * 
     * @return property maximumLength
     */
    @Property(name="maximumLength")
    @JsonIgnore
    public Optional<Long> getMaximumLength() {
        return Optional.ofNullable(maximumLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code maximumLength}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Maximum length of string. Valid values 0 to 87516”</i>
     * 
     * @param maximumLength
     *            new value of {@code maximumLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maximumLength} field changed
     */
    public DeviceManagementConfigurationStringSettingValueDefinition withMaximumLength(Long maximumLength) {
        DeviceManagementConfigurationStringSettingValueDefinition _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationStringSettingValueDefinition");
        _x.maximumLength = maximumLength;
        return _x;
    }

    /**
     * <i>“Minimum length of string. Valid values 0 to 87516”</i>
     * 
     * @return property minimumLength
     */
    @Property(name="minimumLength")
    @JsonIgnore
    public Optional<Long> getMinimumLength() {
        return Optional.ofNullable(minimumLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code minimumLength}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Minimum length of string. Valid values 0 to 87516”</i>
     * 
     * @param minimumLength
     *            new value of {@code minimumLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumLength} field changed
     */
    public DeviceManagementConfigurationStringSettingValueDefinition withMinimumLength(Long minimumLength) {
        DeviceManagementConfigurationStringSettingValueDefinition _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationStringSettingValueDefinition");
        _x.minimumLength = minimumLength;
        return _x;
    }

    public DeviceManagementConfigurationStringSettingValueDefinition withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationStringSettingValueDefinition _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementConfigurationStringSettingValueDefinition() {
        return new Builder();
    }

    public static final class Builder {
        private DeviceManagementConfigurationStringFormat format;
        private String inputValidationSchema;
        private Boolean isSecret;
        private Long maximumLength;
        private Long minimumLength;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Pre-defined format of the string”</i>
         * 
         * @param format
         *            value of {@code format} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder format(DeviceManagementConfigurationStringFormat format) {
            this.format = format;
            this.changedFields = changedFields.add("format");
            return this;
        }

        /**
         * <i>“Regular expression or any xml or json schema that the input string should match”</i>
         * 
         * @param inputValidationSchema
         *            value of {@code inputValidationSchema} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder inputValidationSchema(String inputValidationSchema) {
            this.inputValidationSchema = inputValidationSchema;
            this.changedFields = changedFields.add("inputValidationSchema");
            return this;
        }

        /**
         * <i>“Specifies whether the setting needs to be treated as a secret. Settings marked
         * as yes will be encrypted in transit and at rest and will be displayed as
         * asterisks when represented in the UX.”</i>
         * 
         * @param isSecret
         *            value of {@code isSecret} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isSecret(Boolean isSecret) {
            this.isSecret = isSecret;
            this.changedFields = changedFields.add("isSecret");
            return this;
        }

        /**
         * <i>“Maximum length of string. Valid values 0 to 87516”</i>
         * 
         * @param maximumLength
         *            value of {@code maximumLength} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maximumLength(Long maximumLength) {
            this.maximumLength = maximumLength;
            this.changedFields = changedFields.add("maximumLength");
            return this;
        }

        /**
         * <i>“Minimum length of string. Valid values 0 to 87516”</i>
         * 
         * @param minimumLength
         *            value of {@code minimumLength} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumLength(Long minimumLength) {
            this.minimumLength = minimumLength;
            this.changedFields = changedFields.add("minimumLength");
            return this;
        }

        public DeviceManagementConfigurationStringSettingValueDefinition build() {
            DeviceManagementConfigurationStringSettingValueDefinition _x = new DeviceManagementConfigurationStringSettingValueDefinition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationStringSettingValueDefinition";
            _x.format = format;
            _x.inputValidationSchema = inputValidationSchema;
            _x.isSecret = isSecret;
            _x.maximumLength = maximumLength;
            _x.minimumLength = minimumLength;
            return _x;
        }
    }

    private DeviceManagementConfigurationStringSettingValueDefinition _copy() {
        DeviceManagementConfigurationStringSettingValueDefinition _x = new DeviceManagementConfigurationStringSettingValueDefinition();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.format = format;
        _x.inputValidationSchema = inputValidationSchema;
        _x.isSecret = isSecret;
        _x.maximumLength = maximumLength;
        _x.minimumLength = minimumLength;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationStringSettingValueDefinition[");
        b.append("format=");
        b.append(this.format);
        b.append(", ");
        b.append("inputValidationSchema=");
        b.append(this.inputValidationSchema);
        b.append(", ");
        b.append("isSecret=");
        b.append(this.isSecret);
        b.append(", ");
        b.append("maximumLength=");
        b.append(this.maximumLength);
        b.append(", ");
        b.append("minimumLength=");
        b.append(this.minimumLength);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
