package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Simple Setting Instance Template”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "simpleSettingValueTemplate"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationSimpleSettingInstanceTemplate extends DeviceManagementConfigurationSettingInstanceTemplate implements ODataType {

    @JsonProperty("simpleSettingValueTemplate")
    protected DeviceManagementConfigurationSimpleSettingValueTemplate simpleSettingValueTemplate;

    protected DeviceManagementConfigurationSimpleSettingInstanceTemplate() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationSimpleSettingInstanceTemplate";
    }

    /**
     * <i>“Simple Setting Value Template”</i>
     * 
     * @return property simpleSettingValueTemplate
     */
    @Property(name="simpleSettingValueTemplate")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationSimpleSettingValueTemplate> getSimpleSettingValueTemplate() {
        return Optional.ofNullable(simpleSettingValueTemplate);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * simpleSettingValueTemplate} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Simple Setting Value Template”</i>
     * 
     * @param simpleSettingValueTemplate
     *            new value of {@code simpleSettingValueTemplate} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code simpleSettingValueTemplate} field changed
     */
    public DeviceManagementConfigurationSimpleSettingInstanceTemplate withSimpleSettingValueTemplate(DeviceManagementConfigurationSimpleSettingValueTemplate simpleSettingValueTemplate) {
        DeviceManagementConfigurationSimpleSettingInstanceTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSimpleSettingInstanceTemplate");
        _x.simpleSettingValueTemplate = simpleSettingValueTemplate;
        return _x;
    }

    public DeviceManagementConfigurationSimpleSettingInstanceTemplate withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationSimpleSettingInstanceTemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementConfigurationSimpleSettingInstanceTemplate() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isRequired;
        private String settingDefinitionId;
        private String settingInstanceTemplateId;
        private DeviceManagementConfigurationSimpleSettingValueTemplate simpleSettingValueTemplate;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            this.changedFields = changedFields.add("isRequired");
            return this;
        }

        public Builder settingDefinitionId(String settingDefinitionId) {
            this.settingDefinitionId = settingDefinitionId;
            this.changedFields = changedFields.add("settingDefinitionId");
            return this;
        }

        public Builder settingInstanceTemplateId(String settingInstanceTemplateId) {
            this.settingInstanceTemplateId = settingInstanceTemplateId;
            this.changedFields = changedFields.add("settingInstanceTemplateId");
            return this;
        }

        /**
         * <i>“Simple Setting Value Template”</i>
         * 
         * @param simpleSettingValueTemplate
         *            value of {@code simpleSettingValueTemplate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder simpleSettingValueTemplate(DeviceManagementConfigurationSimpleSettingValueTemplate simpleSettingValueTemplate) {
            this.simpleSettingValueTemplate = simpleSettingValueTemplate;
            this.changedFields = changedFields.add("simpleSettingValueTemplate");
            return this;
        }

        public DeviceManagementConfigurationSimpleSettingInstanceTemplate build() {
            DeviceManagementConfigurationSimpleSettingInstanceTemplate _x = new DeviceManagementConfigurationSimpleSettingInstanceTemplate();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationSimpleSettingInstanceTemplate";
            _x.isRequired = isRequired;
            _x.settingDefinitionId = settingDefinitionId;
            _x.settingInstanceTemplateId = settingInstanceTemplateId;
            _x.simpleSettingValueTemplate = simpleSettingValueTemplate;
            return _x;
        }
    }

    private DeviceManagementConfigurationSimpleSettingInstanceTemplate _copy() {
        DeviceManagementConfigurationSimpleSettingInstanceTemplate _x = new DeviceManagementConfigurationSimpleSettingInstanceTemplate();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isRequired = isRequired;
        _x.settingDefinitionId = settingDefinitionId;
        _x.settingInstanceTemplateId = settingInstanceTemplateId;
        _x.simpleSettingValueTemplate = simpleSettingValueTemplate;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationSimpleSettingInstanceTemplate[");
        b.append("isRequired=");
        b.append(this.isRequired);
        b.append(", ");
        b.append("settingDefinitionId=");
        b.append(this.settingDefinitionId);
        b.append(", ");
        b.append("settingInstanceTemplateId=");
        b.append(this.settingInstanceTemplateId);
        b.append(", ");
        b.append("simpleSettingValueTemplate=");
        b.append(this.simpleSettingValueTemplate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
