package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Simple Setting Collection Instance Template”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "allowUnmanagedValues", 
    "simpleSettingCollectionValueTemplate"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationSimpleSettingCollectionInstanceTemplate extends DeviceManagementConfigurationSettingInstanceTemplate implements ODataType {

    @JsonProperty("allowUnmanagedValues")
    protected Boolean allowUnmanagedValues;

    @JsonProperty("simpleSettingCollectionValueTemplate")
    protected List<DeviceManagementConfigurationSimpleSettingValueTemplate> simpleSettingCollectionValueTemplate;

    @JsonProperty("simpleSettingCollectionValueTemplate@nextLink")
    protected String simpleSettingCollectionValueTemplateNextLink;

    protected DeviceManagementConfigurationSimpleSettingCollectionInstanceTemplate() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationSimpleSettingCollectionInstanceTemplate";
    }

    /**
     * <i>“Linked policy may append values which are not present in the template.”</i>
     * 
     * @return property allowUnmanagedValues
     */
    @Property(name="allowUnmanagedValues")
    @JsonIgnore
    public Optional<Boolean> getAllowUnmanagedValues() {
        return Optional.ofNullable(allowUnmanagedValues);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowUnmanagedValues} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Linked policy may append values which are not present in the template.”</i>
     * 
     * @param allowUnmanagedValues
     *            new value of {@code allowUnmanagedValues} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowUnmanagedValues} field changed
     */
    public DeviceManagementConfigurationSimpleSettingCollectionInstanceTemplate withAllowUnmanagedValues(Boolean allowUnmanagedValues) {
        DeviceManagementConfigurationSimpleSettingCollectionInstanceTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSimpleSettingCollectionInstanceTemplate");
        _x.allowUnmanagedValues = allowUnmanagedValues;
        return _x;
    }

    /**
     * <i>“Simple Setting Collection Value Template”</i>
     * 
     * @return property simpleSettingCollectionValueTemplate
     */
    @Property(name="simpleSettingCollectionValueTemplate")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationSimpleSettingValueTemplate> getSimpleSettingCollectionValueTemplate() {
        return new CollectionPage<DeviceManagementConfigurationSimpleSettingValueTemplate>(contextPath, DeviceManagementConfigurationSimpleSettingValueTemplate.class, this.simpleSettingCollectionValueTemplate, Optional.ofNullable(simpleSettingCollectionValueTemplateNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Simple Setting Collection Value Template”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property simpleSettingCollectionValueTemplate
     */
    @Property(name="simpleSettingCollectionValueTemplate")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationSimpleSettingValueTemplate> getSimpleSettingCollectionValueTemplate(HttpRequestOptions options) {
        return new CollectionPage<DeviceManagementConfigurationSimpleSettingValueTemplate>(contextPath, DeviceManagementConfigurationSimpleSettingValueTemplate.class, this.simpleSettingCollectionValueTemplate, Optional.ofNullable(simpleSettingCollectionValueTemplateNextLink), Collections.emptyList(), options);
    }

    public DeviceManagementConfigurationSimpleSettingCollectionInstanceTemplate withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationSimpleSettingCollectionInstanceTemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementConfigurationSimpleSettingCollectionInstanceTemplate() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isRequired;
        private String settingDefinitionId;
        private String settingInstanceTemplateId;
        private Boolean allowUnmanagedValues;
        private List<DeviceManagementConfigurationSimpleSettingValueTemplate> simpleSettingCollectionValueTemplate;
        private String simpleSettingCollectionValueTemplateNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            this.changedFields = changedFields.add("isRequired");
            return this;
        }

        public Builder settingDefinitionId(String settingDefinitionId) {
            this.settingDefinitionId = settingDefinitionId;
            this.changedFields = changedFields.add("settingDefinitionId");
            return this;
        }

        public Builder settingInstanceTemplateId(String settingInstanceTemplateId) {
            this.settingInstanceTemplateId = settingInstanceTemplateId;
            this.changedFields = changedFields.add("settingInstanceTemplateId");
            return this;
        }

        /**
         * <i>“Linked policy may append values which are not present in the template.”</i>
         * 
         * @param allowUnmanagedValues
         *            value of {@code allowUnmanagedValues} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowUnmanagedValues(Boolean allowUnmanagedValues) {
            this.allowUnmanagedValues = allowUnmanagedValues;
            this.changedFields = changedFields.add("allowUnmanagedValues");
            return this;
        }

        /**
         * <i>“Simple Setting Collection Value Template”</i>
         * 
         * @param simpleSettingCollectionValueTemplate
         *            value of {@code simpleSettingCollectionValueTemplate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder simpleSettingCollectionValueTemplate(List<DeviceManagementConfigurationSimpleSettingValueTemplate> simpleSettingCollectionValueTemplate) {
            this.simpleSettingCollectionValueTemplate = simpleSettingCollectionValueTemplate;
            this.changedFields = changedFields.add("simpleSettingCollectionValueTemplate");
            return this;
        }

        /**
         * <i>“Simple Setting Collection Value Template”</i>
         * 
         * @param simpleSettingCollectionValueTemplate
         *            value of {@code simpleSettingCollectionValueTemplate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder simpleSettingCollectionValueTemplate(DeviceManagementConfigurationSimpleSettingValueTemplate... simpleSettingCollectionValueTemplate) {
            return simpleSettingCollectionValueTemplate(Arrays.asList(simpleSettingCollectionValueTemplate));
        }

        /**
         * <i>“Simple Setting Collection Value Template”</i>
         * 
         * @param simpleSettingCollectionValueTemplateNextLink
         *            value of {@code simpleSettingCollectionValueTemplate@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder simpleSettingCollectionValueTemplateNextLink(String simpleSettingCollectionValueTemplateNextLink) {
            this.simpleSettingCollectionValueTemplateNextLink = simpleSettingCollectionValueTemplateNextLink;
            this.changedFields = changedFields.add("simpleSettingCollectionValueTemplate");
            return this;
        }

        public DeviceManagementConfigurationSimpleSettingCollectionInstanceTemplate build() {
            DeviceManagementConfigurationSimpleSettingCollectionInstanceTemplate _x = new DeviceManagementConfigurationSimpleSettingCollectionInstanceTemplate();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationSimpleSettingCollectionInstanceTemplate";
            _x.isRequired = isRequired;
            _x.settingDefinitionId = settingDefinitionId;
            _x.settingInstanceTemplateId = settingInstanceTemplateId;
            _x.allowUnmanagedValues = allowUnmanagedValues;
            _x.simpleSettingCollectionValueTemplate = simpleSettingCollectionValueTemplate;
            _x.simpleSettingCollectionValueTemplateNextLink = simpleSettingCollectionValueTemplateNextLink;
            return _x;
        }
    }

    private DeviceManagementConfigurationSimpleSettingCollectionInstanceTemplate _copy() {
        DeviceManagementConfigurationSimpleSettingCollectionInstanceTemplate _x = new DeviceManagementConfigurationSimpleSettingCollectionInstanceTemplate();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isRequired = isRequired;
        _x.settingDefinitionId = settingDefinitionId;
        _x.settingInstanceTemplateId = settingInstanceTemplateId;
        _x.allowUnmanagedValues = allowUnmanagedValues;
        _x.simpleSettingCollectionValueTemplate = simpleSettingCollectionValueTemplate;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationSimpleSettingCollectionInstanceTemplate[");
        b.append("isRequired=");
        b.append(this.isRequired);
        b.append(", ");
        b.append("settingDefinitionId=");
        b.append(this.settingDefinitionId);
        b.append(", ");
        b.append("settingInstanceTemplateId=");
        b.append(this.settingInstanceTemplateId);
        b.append(", ");
        b.append("allowUnmanagedValues=");
        b.append(this.allowUnmanagedValues);
        b.append(", ");
        b.append("simpleSettingCollectionValueTemplate=");
        b.append(this.simpleSettingCollectionValueTemplate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
