package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Setting value template reference information”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "settingValueTemplateId", 
    "useTemplateDefault"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationSettingValueTemplateReference implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("settingValueTemplateId")
    protected String settingValueTemplateId;

    @JsonProperty("useTemplateDefault")
    protected Boolean useTemplateDefault;

    protected DeviceManagementConfigurationSettingValueTemplateReference() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationSettingValueTemplateReference";
    }

    /**
     * <i>“Setting value template id”</i>
     * 
     * @return property settingValueTemplateId
     */
    @Property(name="settingValueTemplateId")
    @JsonIgnore
    public Optional<String> getSettingValueTemplateId() {
        return Optional.ofNullable(settingValueTemplateId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingValueTemplateId} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Setting value template id”</i>
     * 
     * @param settingValueTemplateId
     *            new value of {@code settingValueTemplateId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingValueTemplateId} field changed
     */
    public DeviceManagementConfigurationSettingValueTemplateReference withSettingValueTemplateId(String settingValueTemplateId) {
        DeviceManagementConfigurationSettingValueTemplateReference _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingValueTemplateReference");
        _x.settingValueTemplateId = settingValueTemplateId;
        return _x;
    }

    /**
     * <i>“Indicates whether to update policy setting value to match template setting
     * default value”</i>
     * 
     * @return property useTemplateDefault
     */
    @Property(name="useTemplateDefault")
    @JsonIgnore
    public Optional<Boolean> getUseTemplateDefault() {
        return Optional.ofNullable(useTemplateDefault);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * useTemplateDefault} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether to update policy setting value to match template setting
     * default value”</i>
     * 
     * @param useTemplateDefault
     *            new value of {@code useTemplateDefault} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code useTemplateDefault} field changed
     */
    public DeviceManagementConfigurationSettingValueTemplateReference withUseTemplateDefault(Boolean useTemplateDefault) {
        DeviceManagementConfigurationSettingValueTemplateReference _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingValueTemplateReference");
        _x.useTemplateDefault = useTemplateDefault;
        return _x;
    }

    public DeviceManagementConfigurationSettingValueTemplateReference withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationSettingValueTemplateReference _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String settingValueTemplateId;
        private Boolean useTemplateDefault;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Setting value template id”</i>
         * 
         * @param settingValueTemplateId
         *            value of {@code settingValueTemplateId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingValueTemplateId(String settingValueTemplateId) {
            this.settingValueTemplateId = settingValueTemplateId;
            this.changedFields = changedFields.add("settingValueTemplateId");
            return this;
        }

        /**
         * <i>“Indicates whether to update policy setting value to match template setting
         * default value”</i>
         * 
         * @param useTemplateDefault
         *            value of {@code useTemplateDefault} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder useTemplateDefault(Boolean useTemplateDefault) {
            this.useTemplateDefault = useTemplateDefault;
            this.changedFields = changedFields.add("useTemplateDefault");
            return this;
        }

        public DeviceManagementConfigurationSettingValueTemplateReference build() {
            DeviceManagementConfigurationSettingValueTemplateReference _x = new DeviceManagementConfigurationSettingValueTemplateReference();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationSettingValueTemplateReference";
            _x.settingValueTemplateId = settingValueTemplateId;
            _x.useTemplateDefault = useTemplateDefault;
            return _x;
        }
    }

    private DeviceManagementConfigurationSettingValueTemplateReference _copy() {
        DeviceManagementConfigurationSettingValueTemplateReference _x = new DeviceManagementConfigurationSettingValueTemplateReference();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.settingValueTemplateId = settingValueTemplateId;
        _x.useTemplateDefault = useTemplateDefault;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationSettingValueTemplateReference[");
        b.append("settingValueTemplateId=");
        b.append(this.settingValueTemplateId);
        b.append(", ");
        b.append("useTemplateDefault=");
        b.append(this.useTemplateDefault);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
