package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Setting instance within policy”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "settingDefinitionId", 
    "settingInstanceTemplateReference"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationSettingInstance implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("settingDefinitionId")
    protected String settingDefinitionId;

    @JsonProperty("settingInstanceTemplateReference")
    protected DeviceManagementConfigurationSettingInstanceTemplateReference settingInstanceTemplateReference;

    protected DeviceManagementConfigurationSettingInstance() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationSettingInstance";
    }

    /**
     * <i>“Setting Definition Id”</i>
     * 
     * @return property settingDefinitionId
     */
    @Property(name="settingDefinitionId")
    @JsonIgnore
    public Optional<String> getSettingDefinitionId() {
        return Optional.ofNullable(settingDefinitionId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingDefinitionId} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Setting Definition Id”</i>
     * 
     * @param settingDefinitionId
     *            new value of {@code settingDefinitionId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingDefinitionId} field changed
     */
    public DeviceManagementConfigurationSettingInstance withSettingDefinitionId(String settingDefinitionId) {
        DeviceManagementConfigurationSettingInstance _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingInstance");
        _x.settingDefinitionId = settingDefinitionId;
        return _x;
    }

    /**
     * <i>“Setting Instance Template Reference”</i>
     * 
     * @return property settingInstanceTemplateReference
     */
    @Property(name="settingInstanceTemplateReference")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationSettingInstanceTemplateReference> getSettingInstanceTemplateReference() {
        return Optional.ofNullable(settingInstanceTemplateReference);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingInstanceTemplateReference} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Setting Instance Template Reference”</i>
     * 
     * @param settingInstanceTemplateReference
     *            new value of {@code settingInstanceTemplateReference} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingInstanceTemplateReference} field changed
     */
    public DeviceManagementConfigurationSettingInstance withSettingInstanceTemplateReference(DeviceManagementConfigurationSettingInstanceTemplateReference settingInstanceTemplateReference) {
        DeviceManagementConfigurationSettingInstance _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingInstance");
        _x.settingInstanceTemplateReference = settingInstanceTemplateReference;
        return _x;
    }

    public DeviceManagementConfigurationSettingInstance withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationSettingInstance _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    private DeviceManagementConfigurationSettingInstance _copy() {
        DeviceManagementConfigurationSettingInstance _x = new DeviceManagementConfigurationSettingInstance();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.settingDefinitionId = settingDefinitionId;
        _x.settingInstanceTemplateReference = settingInstanceTemplateReference;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationSettingInstance[");
        b.append("settingDefinitionId=");
        b.append(this.settingDefinitionId);
        b.append(", ");
        b.append("settingInstanceTemplateReference=");
        b.append(this.settingInstanceTemplateReference);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
