package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;


/**
 * <i>“Setting instance within policy”</i>
 */@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationSettingGroupCollectionInstance extends DeviceManagementConfigurationSettingInstance implements ODataType {

    protected DeviceManagementConfigurationSettingGroupCollectionInstance() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationSettingGroupCollectionInstance";
    }

    public DeviceManagementConfigurationSettingGroupCollectionInstance withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationSettingGroupCollectionInstance _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementConfigurationSettingGroupCollectionInstance() {
        return new Builder();
    }

    public static final class Builder {
        private String settingDefinitionId;
        private DeviceManagementConfigurationSettingInstanceTemplateReference settingInstanceTemplateReference;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder settingDefinitionId(String settingDefinitionId) {
            this.settingDefinitionId = settingDefinitionId;
            this.changedFields = changedFields.add("settingDefinitionId");
            return this;
        }

        public Builder settingInstanceTemplateReference(DeviceManagementConfigurationSettingInstanceTemplateReference settingInstanceTemplateReference) {
            this.settingInstanceTemplateReference = settingInstanceTemplateReference;
            this.changedFields = changedFields.add("settingInstanceTemplateReference");
            return this;
        }

        public DeviceManagementConfigurationSettingGroupCollectionInstance build() {
            DeviceManagementConfigurationSettingGroupCollectionInstance _x = new DeviceManagementConfigurationSettingGroupCollectionInstance();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationSettingGroupCollectionInstance";
            _x.settingDefinitionId = settingDefinitionId;
            _x.settingInstanceTemplateReference = settingInstanceTemplateReference;
            return _x;
        }
    }

    private DeviceManagementConfigurationSettingGroupCollectionInstance _copy() {
        DeviceManagementConfigurationSettingGroupCollectionInstance _x = new DeviceManagementConfigurationSettingGroupCollectionInstance();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.settingDefinitionId = settingDefinitionId;
        _x.settingInstanceTemplateReference = settingInstanceTemplateReference;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationSettingGroupCollectionInstance[");
        b.append("settingDefinitionId=");
        b.append(this.settingDefinitionId);
        b.append(", ");
        b.append("settingInstanceTemplateReference=");
        b.append(this.settingInstanceTemplateReference);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
