package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "dependedOnBy", 
    "required"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationSettingDependedOnBy implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("dependedOnBy")
    protected String dependedOnBy;

    @JsonProperty("required")
    protected Boolean required;

    protected DeviceManagementConfigurationSettingDependedOnBy() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationSettingDependedOnBy";
    }

    /**
     * <i>“Identifier of child setting that is dependent on the current setting”</i>
     * 
     * @return property dependedOnBy
     */
    @Property(name="dependedOnBy")
    @JsonIgnore
    public Optional<String> getDependedOnBy() {
        return Optional.ofNullable(dependedOnBy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code dependedOnBy}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Identifier of child setting that is dependent on the current setting”</i>
     * 
     * @param dependedOnBy
     *            new value of {@code dependedOnBy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dependedOnBy} field changed
     */
    public DeviceManagementConfigurationSettingDependedOnBy withDependedOnBy(String dependedOnBy) {
        DeviceManagementConfigurationSettingDependedOnBy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingDependedOnBy");
        _x.dependedOnBy = dependedOnBy;
        return _x;
    }

    /**
     * <i>“Value that determines if the child setting is required based on the parent
     * setting's selection”</i>
     * 
     * @return property required
     */
    @Property(name="required")
    @JsonIgnore
    public Optional<Boolean> getRequired() {
        return Optional.ofNullable(required);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code required} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Value that determines if the child setting is required based on the parent
     * setting's selection”</i>
     * 
     * @param required
     *            new value of {@code required} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code required} field changed
     */
    public DeviceManagementConfigurationSettingDependedOnBy withRequired(Boolean required) {
        DeviceManagementConfigurationSettingDependedOnBy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingDependedOnBy");
        _x.required = required;
        return _x;
    }

    public DeviceManagementConfigurationSettingDependedOnBy withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationSettingDependedOnBy _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String dependedOnBy;
        private Boolean required;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Identifier of child setting that is dependent on the current setting”</i>
         * 
         * @param dependedOnBy
         *            value of {@code dependedOnBy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dependedOnBy(String dependedOnBy) {
            this.dependedOnBy = dependedOnBy;
            this.changedFields = changedFields.add("dependedOnBy");
            return this;
        }

        /**
         * <i>“Value that determines if the child setting is required based on the parent
         * setting's selection”</i>
         * 
         * @param required
         *            value of {@code required} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder required(Boolean required) {
            this.required = required;
            this.changedFields = changedFields.add("required");
            return this;
        }

        public DeviceManagementConfigurationSettingDependedOnBy build() {
            DeviceManagementConfigurationSettingDependedOnBy _x = new DeviceManagementConfigurationSettingDependedOnBy();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationSettingDependedOnBy";
            _x.dependedOnBy = dependedOnBy;
            _x.required = required;
            return _x;
        }
    }

    private DeviceManagementConfigurationSettingDependedOnBy _copy() {
        DeviceManagementConfigurationSettingDependedOnBy _x = new DeviceManagementConfigurationSettingDependedOnBy();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.dependedOnBy = dependedOnBy;
        _x.required = required;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationSettingDependedOnBy[");
        b.append("dependedOnBy=");
        b.append(this.dependedOnBy);
        b.append(", ");
        b.append("required=");
        b.append(this.required);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
