package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceManagementConfigurationDeviceMode;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationPlatforms;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationTechnologies;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "deviceMode", 
    "platform", 
    "technologies"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationSettingApplicability implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("deviceMode")
    protected DeviceManagementConfigurationDeviceMode deviceMode;

    @JsonProperty("platform")
    protected DeviceManagementConfigurationPlatforms platform;

    @JsonProperty("technologies")
    protected DeviceManagementConfigurationTechnologies technologies;

    protected DeviceManagementConfigurationSettingApplicability() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationSettingApplicability";
    }

    /**
     * <i>“description of the setting”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“description of the setting”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public DeviceManagementConfigurationSettingApplicability withDescription(String description) {
        DeviceManagementConfigurationSettingApplicability _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingApplicability");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Device Mode that setting can be applied on”</i>
     * 
     * @return property deviceMode
     */
    @Property(name="deviceMode")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationDeviceMode> getDeviceMode() {
        return Optional.ofNullable(deviceMode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceMode} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Device Mode that setting can be applied on”</i>
     * 
     * @param deviceMode
     *            new value of {@code deviceMode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceMode} field changed
     */
    public DeviceManagementConfigurationSettingApplicability withDeviceMode(DeviceManagementConfigurationDeviceMode deviceMode) {
        DeviceManagementConfigurationSettingApplicability _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingApplicability");
        _x.deviceMode = deviceMode;
        return _x;
    }

    /**
     * <i>“Platform setting can be applied on”</i>
     * 
     * @return property platform
     */
    @Property(name="platform")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationPlatforms> getPlatform() {
        return Optional.ofNullable(platform);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code platform} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Platform setting can be applied on”</i>
     * 
     * @param platform
     *            new value of {@code platform} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code platform} field changed
     */
    public DeviceManagementConfigurationSettingApplicability withPlatform(DeviceManagementConfigurationPlatforms platform) {
        DeviceManagementConfigurationSettingApplicability _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingApplicability");
        _x.platform = platform;
        return _x;
    }

    /**
     * <i>“Which technology channels this setting can be deployed through”</i>
     * 
     * @return property technologies
     */
    @Property(name="technologies")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationTechnologies> getTechnologies() {
        return Optional.ofNullable(technologies);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code technologies}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Which technology channels this setting can be deployed through”</i>
     * 
     * @param technologies
     *            new value of {@code technologies} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code technologies} field changed
     */
    public DeviceManagementConfigurationSettingApplicability withTechnologies(DeviceManagementConfigurationTechnologies technologies) {
        DeviceManagementConfigurationSettingApplicability _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingApplicability");
        _x.technologies = technologies;
        return _x;
    }

    public DeviceManagementConfigurationSettingApplicability withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationSettingApplicability _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String description;
        private DeviceManagementConfigurationDeviceMode deviceMode;
        private DeviceManagementConfigurationPlatforms platform;
        private DeviceManagementConfigurationTechnologies technologies;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“description of the setting”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“Device Mode that setting can be applied on”</i>
         * 
         * @param deviceMode
         *            value of {@code deviceMode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceMode(DeviceManagementConfigurationDeviceMode deviceMode) {
            this.deviceMode = deviceMode;
            this.changedFields = changedFields.add("deviceMode");
            return this;
        }

        /**
         * <i>“Platform setting can be applied on”</i>
         * 
         * @param platform
         *            value of {@code platform} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder platform(DeviceManagementConfigurationPlatforms platform) {
            this.platform = platform;
            this.changedFields = changedFields.add("platform");
            return this;
        }

        /**
         * <i>“Which technology channels this setting can be deployed through”</i>
         * 
         * @param technologies
         *            value of {@code technologies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder technologies(DeviceManagementConfigurationTechnologies technologies) {
            this.technologies = technologies;
            this.changedFields = changedFields.add("technologies");
            return this;
        }

        public DeviceManagementConfigurationSettingApplicability build() {
            DeviceManagementConfigurationSettingApplicability _x = new DeviceManagementConfigurationSettingApplicability();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationSettingApplicability";
            _x.description = description;
            _x.deviceMode = deviceMode;
            _x.platform = platform;
            _x.technologies = technologies;
            return _x;
        }
    }

    private DeviceManagementConfigurationSettingApplicability _copy() {
        DeviceManagementConfigurationSettingApplicability _x = new DeviceManagementConfigurationSettingApplicability();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.description = description;
        _x.deviceMode = deviceMode;
        _x.platform = platform;
        _x.technologies = technologies;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationSettingApplicability[");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceMode=");
        b.append(this.deviceMode);
        b.append(", ");
        b.append("platform=");
        b.append(this.platform);
        b.append(", ");
        b.append("technologies=");
        b.append(this.technologies);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
