package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Integer Setting Value Constant Default Template”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "constantValue"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationIntegerSettingValueConstantDefaultTemplate extends DeviceManagementConfigurationIntegerSettingValueDefaultTemplate implements ODataType {

    @JsonProperty("constantValue")
    protected Integer constantValue;

    protected DeviceManagementConfigurationIntegerSettingValueConstantDefaultTemplate() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationIntegerSettingValueConstantDefaultTemplate";
    }

    /**
     * <i>“Default Constant Value. Valid values -2147483648 to 2147483647”</i>
     * 
     * @return property constantValue
     */
    @Property(name="constantValue")
    @JsonIgnore
    public Optional<Integer> getConstantValue() {
        return Optional.ofNullable(constantValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code constantValue}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Default Constant Value. Valid values -2147483648 to 2147483647”</i>
     * 
     * @param constantValue
     *            new value of {@code constantValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code constantValue} field changed
     */
    public DeviceManagementConfigurationIntegerSettingValueConstantDefaultTemplate withConstantValue(Integer constantValue) {
        DeviceManagementConfigurationIntegerSettingValueConstantDefaultTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationIntegerSettingValueConstantDefaultTemplate");
        _x.constantValue = constantValue;
        return _x;
    }

    public DeviceManagementConfigurationIntegerSettingValueConstantDefaultTemplate withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationIntegerSettingValueConstantDefaultTemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementConfigurationIntegerSettingValueConstantDefaultTemplate() {
        return new Builder();
    }

    public static final class Builder {
        private Integer constantValue;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Default Constant Value. Valid values -2147483648 to 2147483647”</i>
         * 
         * @param constantValue
         *            value of {@code constantValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder constantValue(Integer constantValue) {
            this.constantValue = constantValue;
            this.changedFields = changedFields.add("constantValue");
            return this;
        }

        public DeviceManagementConfigurationIntegerSettingValueConstantDefaultTemplate build() {
            DeviceManagementConfigurationIntegerSettingValueConstantDefaultTemplate _x = new DeviceManagementConfigurationIntegerSettingValueConstantDefaultTemplate();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationIntegerSettingValueConstantDefaultTemplate";
            _x.constantValue = constantValue;
            return _x;
        }
    }

    private DeviceManagementConfigurationIntegerSettingValueConstantDefaultTemplate _copy() {
        DeviceManagementConfigurationIntegerSettingValueConstantDefaultTemplate _x = new DeviceManagementConfigurationIntegerSettingValueConstantDefaultTemplate();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.constantValue = constantValue;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationIntegerSettingValueConstantDefaultTemplate[");
        b.append("constantValue=");
        b.append(this.constantValue);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
