package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Simple setting value”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "value"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationIntegerSettingValue extends DeviceManagementConfigurationSimpleSettingValue implements ODataType {

    @JsonProperty("value")
    protected Integer value;

    protected DeviceManagementConfigurationIntegerSettingValue() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationIntegerSettingValue";
    }

    /**
     * <i>“Value of the integer setting.”</i>
     * 
     * @return property value
     */
    @Property(name="value")
    @JsonIgnore
    public Optional<Integer> getValue() {
        return Optional.ofNullable(value);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code value} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Value of the integer setting.”</i>
     * 
     * @param value
     *            new value of {@code value} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code value} field changed
     */
    public DeviceManagementConfigurationIntegerSettingValue withValue(Integer value) {
        DeviceManagementConfigurationIntegerSettingValue _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationIntegerSettingValue");
        _x.value = value;
        return _x;
    }

    public DeviceManagementConfigurationIntegerSettingValue withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationIntegerSettingValue _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementConfigurationIntegerSettingValue() {
        return new Builder();
    }

    public static final class Builder {
        private DeviceManagementConfigurationSettingValueTemplateReference settingValueTemplateReference;
        private Integer value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder settingValueTemplateReference(DeviceManagementConfigurationSettingValueTemplateReference settingValueTemplateReference) {
            this.settingValueTemplateReference = settingValueTemplateReference;
            this.changedFields = changedFields.add("settingValueTemplateReference");
            return this;
        }

        /**
         * <i>“Value of the integer setting.”</i>
         * 
         * @param value
         *            value of {@code value} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder value(Integer value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public DeviceManagementConfigurationIntegerSettingValue build() {
            DeviceManagementConfigurationIntegerSettingValue _x = new DeviceManagementConfigurationIntegerSettingValue();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationIntegerSettingValue";
            _x.settingValueTemplateReference = settingValueTemplateReference;
            _x.value = value;
            return _x;
        }
    }

    private DeviceManagementConfigurationIntegerSettingValue _copy() {
        DeviceManagementConfigurationIntegerSettingValue _x = new DeviceManagementConfigurationIntegerSettingValue();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.settingValueTemplateReference = settingValueTemplateReference;
        _x.value = value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationIntegerSettingValue[");
        b.append("settingValueTemplateReference=");
        b.append(this.settingValueTemplateReference);
        b.append(", ");
        b.append("value=");
        b.append(this.value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
