package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Group Setting Value Template”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "children", 
    "settingValueTemplateId"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationGroupSettingValueTemplate implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("children")
    protected List<DeviceManagementConfigurationSettingInstanceTemplate> children;

    @JsonProperty("children@nextLink")
    protected String childrenNextLink;

    @JsonProperty("settingValueTemplateId")
    protected String settingValueTemplateId;

    protected DeviceManagementConfigurationGroupSettingValueTemplate() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationGroupSettingValueTemplate";
    }

    /**
     * <i>“Group setting value children”</i>
     * 
     * @return property children
     */
    @Property(name="children")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationSettingInstanceTemplate> getChildren() {
        return new CollectionPage<DeviceManagementConfigurationSettingInstanceTemplate>(contextPath, DeviceManagementConfigurationSettingInstanceTemplate.class, this.children, Optional.ofNullable(childrenNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Group setting value children”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property children
     */
    @Property(name="children")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationSettingInstanceTemplate> getChildren(HttpRequestOptions options) {
        return new CollectionPage<DeviceManagementConfigurationSettingInstanceTemplate>(contextPath, DeviceManagementConfigurationSettingInstanceTemplate.class, this.children, Optional.ofNullable(childrenNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Setting Value Template Id”</i>
     * 
     * @return property settingValueTemplateId
     */
    @Property(name="settingValueTemplateId")
    @JsonIgnore
    public Optional<String> getSettingValueTemplateId() {
        return Optional.ofNullable(settingValueTemplateId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingValueTemplateId} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Setting Value Template Id”</i>
     * 
     * @param settingValueTemplateId
     *            new value of {@code settingValueTemplateId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingValueTemplateId} field changed
     */
    public DeviceManagementConfigurationGroupSettingValueTemplate withSettingValueTemplateId(String settingValueTemplateId) {
        DeviceManagementConfigurationGroupSettingValueTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationGroupSettingValueTemplate");
        _x.settingValueTemplateId = settingValueTemplateId;
        return _x;
    }

    public DeviceManagementConfigurationGroupSettingValueTemplate withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationGroupSettingValueTemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<DeviceManagementConfigurationSettingInstanceTemplate> children;
        private String childrenNextLink;
        private String settingValueTemplateId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Group setting value children”</i>
         * 
         * @param children
         *            value of {@code children} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder children(List<DeviceManagementConfigurationSettingInstanceTemplate> children) {
            this.children = children;
            this.changedFields = changedFields.add("children");
            return this;
        }

        /**
         * <i>“Group setting value children”</i>
         * 
         * @param children
         *            value of {@code children} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder children(DeviceManagementConfigurationSettingInstanceTemplate... children) {
            return children(Arrays.asList(children));
        }

        /**
         * <i>“Group setting value children”</i>
         * 
         * @param childrenNextLink
         *            value of {@code children@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder childrenNextLink(String childrenNextLink) {
            this.childrenNextLink = childrenNextLink;
            this.changedFields = changedFields.add("children");
            return this;
        }

        /**
         * <i>“Setting Value Template Id”</i>
         * 
         * @param settingValueTemplateId
         *            value of {@code settingValueTemplateId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingValueTemplateId(String settingValueTemplateId) {
            this.settingValueTemplateId = settingValueTemplateId;
            this.changedFields = changedFields.add("settingValueTemplateId");
            return this;
        }

        public DeviceManagementConfigurationGroupSettingValueTemplate build() {
            DeviceManagementConfigurationGroupSettingValueTemplate _x = new DeviceManagementConfigurationGroupSettingValueTemplate();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationGroupSettingValueTemplate";
            _x.children = children;
            _x.childrenNextLink = childrenNextLink;
            _x.settingValueTemplateId = settingValueTemplateId;
            return _x;
        }
    }

    private DeviceManagementConfigurationGroupSettingValueTemplate _copy() {
        DeviceManagementConfigurationGroupSettingValueTemplate _x = new DeviceManagementConfigurationGroupSettingValueTemplate();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.children = children;
        _x.settingValueTemplateId = settingValueTemplateId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationGroupSettingValueTemplate[");
        b.append("children=");
        b.append(this.children);
        b.append(", ");
        b.append("settingValueTemplateId=");
        b.append(this.settingValueTemplateId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
