package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Group Setting Collection Instance Template”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "allowUnmanagedValues", 
    "groupSettingCollectionValueTemplate"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationGroupSettingCollectionInstanceTemplate extends DeviceManagementConfigurationSettingInstanceTemplate implements ODataType {

    @JsonProperty("allowUnmanagedValues")
    protected Boolean allowUnmanagedValues;

    @JsonProperty("groupSettingCollectionValueTemplate")
    protected List<DeviceManagementConfigurationGroupSettingValueTemplate> groupSettingCollectionValueTemplate;

    @JsonProperty("groupSettingCollectionValueTemplate@nextLink")
    protected String groupSettingCollectionValueTemplateNextLink;

    protected DeviceManagementConfigurationGroupSettingCollectionInstanceTemplate() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationGroupSettingCollectionInstanceTemplate";
    }

    /**
     * <i>“Linked policy may append values which are not present in the template.”</i>
     * 
     * @return property allowUnmanagedValues
     */
    @Property(name="allowUnmanagedValues")
    @JsonIgnore
    public Optional<Boolean> getAllowUnmanagedValues() {
        return Optional.ofNullable(allowUnmanagedValues);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowUnmanagedValues} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Linked policy may append values which are not present in the template.”</i>
     * 
     * @param allowUnmanagedValues
     *            new value of {@code allowUnmanagedValues} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowUnmanagedValues} field changed
     */
    public DeviceManagementConfigurationGroupSettingCollectionInstanceTemplate withAllowUnmanagedValues(Boolean allowUnmanagedValues) {
        DeviceManagementConfigurationGroupSettingCollectionInstanceTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationGroupSettingCollectionInstanceTemplate");
        _x.allowUnmanagedValues = allowUnmanagedValues;
        return _x;
    }

    /**
     * <i>“Group Setting Collection Value Template”</i>
     * 
     * @return property groupSettingCollectionValueTemplate
     */
    @Property(name="groupSettingCollectionValueTemplate")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationGroupSettingValueTemplate> getGroupSettingCollectionValueTemplate() {
        return new CollectionPage<DeviceManagementConfigurationGroupSettingValueTemplate>(contextPath, DeviceManagementConfigurationGroupSettingValueTemplate.class, this.groupSettingCollectionValueTemplate, Optional.ofNullable(groupSettingCollectionValueTemplateNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Group Setting Collection Value Template”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property groupSettingCollectionValueTemplate
     */
    @Property(name="groupSettingCollectionValueTemplate")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationGroupSettingValueTemplate> getGroupSettingCollectionValueTemplate(HttpRequestOptions options) {
        return new CollectionPage<DeviceManagementConfigurationGroupSettingValueTemplate>(contextPath, DeviceManagementConfigurationGroupSettingValueTemplate.class, this.groupSettingCollectionValueTemplate, Optional.ofNullable(groupSettingCollectionValueTemplateNextLink), Collections.emptyList(), options);
    }

    public DeviceManagementConfigurationGroupSettingCollectionInstanceTemplate withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationGroupSettingCollectionInstanceTemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementConfigurationGroupSettingCollectionInstanceTemplate() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isRequired;
        private String settingDefinitionId;
        private String settingInstanceTemplateId;
        private Boolean allowUnmanagedValues;
        private List<DeviceManagementConfigurationGroupSettingValueTemplate> groupSettingCollectionValueTemplate;
        private String groupSettingCollectionValueTemplateNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            this.changedFields = changedFields.add("isRequired");
            return this;
        }

        public Builder settingDefinitionId(String settingDefinitionId) {
            this.settingDefinitionId = settingDefinitionId;
            this.changedFields = changedFields.add("settingDefinitionId");
            return this;
        }

        public Builder settingInstanceTemplateId(String settingInstanceTemplateId) {
            this.settingInstanceTemplateId = settingInstanceTemplateId;
            this.changedFields = changedFields.add("settingInstanceTemplateId");
            return this;
        }

        /**
         * <i>“Linked policy may append values which are not present in the template.”</i>
         * 
         * @param allowUnmanagedValues
         *            value of {@code allowUnmanagedValues} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowUnmanagedValues(Boolean allowUnmanagedValues) {
            this.allowUnmanagedValues = allowUnmanagedValues;
            this.changedFields = changedFields.add("allowUnmanagedValues");
            return this;
        }

        /**
         * <i>“Group Setting Collection Value Template”</i>
         * 
         * @param groupSettingCollectionValueTemplate
         *            value of {@code groupSettingCollectionValueTemplate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupSettingCollectionValueTemplate(List<DeviceManagementConfigurationGroupSettingValueTemplate> groupSettingCollectionValueTemplate) {
            this.groupSettingCollectionValueTemplate = groupSettingCollectionValueTemplate;
            this.changedFields = changedFields.add("groupSettingCollectionValueTemplate");
            return this;
        }

        /**
         * <i>“Group Setting Collection Value Template”</i>
         * 
         * @param groupSettingCollectionValueTemplate
         *            value of {@code groupSettingCollectionValueTemplate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupSettingCollectionValueTemplate(DeviceManagementConfigurationGroupSettingValueTemplate... groupSettingCollectionValueTemplate) {
            return groupSettingCollectionValueTemplate(Arrays.asList(groupSettingCollectionValueTemplate));
        }

        /**
         * <i>“Group Setting Collection Value Template”</i>
         * 
         * @param groupSettingCollectionValueTemplateNextLink
         *            value of {@code groupSettingCollectionValueTemplate@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupSettingCollectionValueTemplateNextLink(String groupSettingCollectionValueTemplateNextLink) {
            this.groupSettingCollectionValueTemplateNextLink = groupSettingCollectionValueTemplateNextLink;
            this.changedFields = changedFields.add("groupSettingCollectionValueTemplate");
            return this;
        }

        public DeviceManagementConfigurationGroupSettingCollectionInstanceTemplate build() {
            DeviceManagementConfigurationGroupSettingCollectionInstanceTemplate _x = new DeviceManagementConfigurationGroupSettingCollectionInstanceTemplate();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationGroupSettingCollectionInstanceTemplate";
            _x.isRequired = isRequired;
            _x.settingDefinitionId = settingDefinitionId;
            _x.settingInstanceTemplateId = settingInstanceTemplateId;
            _x.allowUnmanagedValues = allowUnmanagedValues;
            _x.groupSettingCollectionValueTemplate = groupSettingCollectionValueTemplate;
            _x.groupSettingCollectionValueTemplateNextLink = groupSettingCollectionValueTemplateNextLink;
            return _x;
        }
    }

    private DeviceManagementConfigurationGroupSettingCollectionInstanceTemplate _copy() {
        DeviceManagementConfigurationGroupSettingCollectionInstanceTemplate _x = new DeviceManagementConfigurationGroupSettingCollectionInstanceTemplate();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isRequired = isRequired;
        _x.settingDefinitionId = settingDefinitionId;
        _x.settingInstanceTemplateId = settingInstanceTemplateId;
        _x.allowUnmanagedValues = allowUnmanagedValues;
        _x.groupSettingCollectionValueTemplate = groupSettingCollectionValueTemplate;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationGroupSettingCollectionInstanceTemplate[");
        b.append("isRequired=");
        b.append(this.isRequired);
        b.append(", ");
        b.append("settingDefinitionId=");
        b.append(this.settingDefinitionId);
        b.append(", ");
        b.append("settingInstanceTemplateId=");
        b.append(this.settingInstanceTemplateId);
        b.append(", ");
        b.append("allowUnmanagedValues=");
        b.append(this.allowUnmanagedValues);
        b.append(", ");
        b.append("groupSettingCollectionValueTemplate=");
        b.append(this.groupSettingCollectionValueTemplate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
