package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Choice Setting Value Template”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "defaultValue", 
    "recommendedValueDefinition", 
    "requiredValueDefinition", 
    "settingValueTemplateId"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationChoiceSettingValueTemplate implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("defaultValue")
    protected DeviceManagementConfigurationChoiceSettingValueDefaultTemplate defaultValue;

    @JsonProperty("recommendedValueDefinition")
    protected DeviceManagementConfigurationChoiceSettingValueDefinitionTemplate recommendedValueDefinition;

    @JsonProperty("requiredValueDefinition")
    protected DeviceManagementConfigurationChoiceSettingValueDefinitionTemplate requiredValueDefinition;

    @JsonProperty("settingValueTemplateId")
    protected String settingValueTemplateId;

    protected DeviceManagementConfigurationChoiceSettingValueTemplate() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationChoiceSettingValueTemplate";
    }

    /**
     * <i>“Choice Setting Value Default Template.”</i>
     * 
     * @return property defaultValue
     */
    @Property(name="defaultValue")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationChoiceSettingValueDefaultTemplate> getDefaultValue() {
        return Optional.ofNullable(defaultValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code defaultValue}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Choice Setting Value Default Template.”</i>
     * 
     * @param defaultValue
     *            new value of {@code defaultValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defaultValue} field changed
     */
    public DeviceManagementConfigurationChoiceSettingValueTemplate withDefaultValue(DeviceManagementConfigurationChoiceSettingValueDefaultTemplate defaultValue) {
        DeviceManagementConfigurationChoiceSettingValueTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationChoiceSettingValueTemplate");
        _x.defaultValue = defaultValue;
        return _x;
    }

    /**
     * <i>“Recommended definition override.”</i>
     * 
     * @return property recommendedValueDefinition
     */
    @Property(name="recommendedValueDefinition")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationChoiceSettingValueDefinitionTemplate> getRecommendedValueDefinition() {
        return Optional.ofNullable(recommendedValueDefinition);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * recommendedValueDefinition} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Recommended definition override.”</i>
     * 
     * @param recommendedValueDefinition
     *            new value of {@code recommendedValueDefinition} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code recommendedValueDefinition} field changed
     */
    public DeviceManagementConfigurationChoiceSettingValueTemplate withRecommendedValueDefinition(DeviceManagementConfigurationChoiceSettingValueDefinitionTemplate recommendedValueDefinition) {
        DeviceManagementConfigurationChoiceSettingValueTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationChoiceSettingValueTemplate");
        _x.recommendedValueDefinition = recommendedValueDefinition;
        return _x;
    }

    /**
     * <i>“Required definition override.”</i>
     * 
     * @return property requiredValueDefinition
     */
    @Property(name="requiredValueDefinition")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationChoiceSettingValueDefinitionTemplate> getRequiredValueDefinition() {
        return Optional.ofNullable(requiredValueDefinition);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * requiredValueDefinition} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Required definition override.”</i>
     * 
     * @param requiredValueDefinition
     *            new value of {@code requiredValueDefinition} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requiredValueDefinition} field changed
     */
    public DeviceManagementConfigurationChoiceSettingValueTemplate withRequiredValueDefinition(DeviceManagementConfigurationChoiceSettingValueDefinitionTemplate requiredValueDefinition) {
        DeviceManagementConfigurationChoiceSettingValueTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationChoiceSettingValueTemplate");
        _x.requiredValueDefinition = requiredValueDefinition;
        return _x;
    }

    /**
     * <i>“Setting Value Template Id”</i>
     * 
     * @return property settingValueTemplateId
     */
    @Property(name="settingValueTemplateId")
    @JsonIgnore
    public Optional<String> getSettingValueTemplateId() {
        return Optional.ofNullable(settingValueTemplateId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingValueTemplateId} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Setting Value Template Id”</i>
     * 
     * @param settingValueTemplateId
     *            new value of {@code settingValueTemplateId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingValueTemplateId} field changed
     */
    public DeviceManagementConfigurationChoiceSettingValueTemplate withSettingValueTemplateId(String settingValueTemplateId) {
        DeviceManagementConfigurationChoiceSettingValueTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationChoiceSettingValueTemplate");
        _x.settingValueTemplateId = settingValueTemplateId;
        return _x;
    }

    public DeviceManagementConfigurationChoiceSettingValueTemplate withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationChoiceSettingValueTemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DeviceManagementConfigurationChoiceSettingValueDefaultTemplate defaultValue;
        private DeviceManagementConfigurationChoiceSettingValueDefinitionTemplate recommendedValueDefinition;
        private DeviceManagementConfigurationChoiceSettingValueDefinitionTemplate requiredValueDefinition;
        private String settingValueTemplateId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Choice Setting Value Default Template.”</i>
         * 
         * @param defaultValue
         *            value of {@code defaultValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defaultValue(DeviceManagementConfigurationChoiceSettingValueDefaultTemplate defaultValue) {
            this.defaultValue = defaultValue;
            this.changedFields = changedFields.add("defaultValue");
            return this;
        }

        /**
         * <i>“Recommended definition override.”</i>
         * 
         * @param recommendedValueDefinition
         *            value of {@code recommendedValueDefinition} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder recommendedValueDefinition(DeviceManagementConfigurationChoiceSettingValueDefinitionTemplate recommendedValueDefinition) {
            this.recommendedValueDefinition = recommendedValueDefinition;
            this.changedFields = changedFields.add("recommendedValueDefinition");
            return this;
        }

        /**
         * <i>“Required definition override.”</i>
         * 
         * @param requiredValueDefinition
         *            value of {@code requiredValueDefinition} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requiredValueDefinition(DeviceManagementConfigurationChoiceSettingValueDefinitionTemplate requiredValueDefinition) {
            this.requiredValueDefinition = requiredValueDefinition;
            this.changedFields = changedFields.add("requiredValueDefinition");
            return this;
        }

        /**
         * <i>“Setting Value Template Id”</i>
         * 
         * @param settingValueTemplateId
         *            value of {@code settingValueTemplateId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingValueTemplateId(String settingValueTemplateId) {
            this.settingValueTemplateId = settingValueTemplateId;
            this.changedFields = changedFields.add("settingValueTemplateId");
            return this;
        }

        public DeviceManagementConfigurationChoiceSettingValueTemplate build() {
            DeviceManagementConfigurationChoiceSettingValueTemplate _x = new DeviceManagementConfigurationChoiceSettingValueTemplate();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationChoiceSettingValueTemplate";
            _x.defaultValue = defaultValue;
            _x.recommendedValueDefinition = recommendedValueDefinition;
            _x.requiredValueDefinition = requiredValueDefinition;
            _x.settingValueTemplateId = settingValueTemplateId;
            return _x;
        }
    }

    private DeviceManagementConfigurationChoiceSettingValueTemplate _copy() {
        DeviceManagementConfigurationChoiceSettingValueTemplate _x = new DeviceManagementConfigurationChoiceSettingValueTemplate();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.defaultValue = defaultValue;
        _x.recommendedValueDefinition = recommendedValueDefinition;
        _x.requiredValueDefinition = requiredValueDefinition;
        _x.settingValueTemplateId = settingValueTemplateId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationChoiceSettingValueTemplate[");
        b.append("defaultValue=");
        b.append(this.defaultValue);
        b.append(", ");
        b.append("recommendedValueDefinition=");
        b.append(this.recommendedValueDefinition);
        b.append(", ");
        b.append("requiredValueDefinition=");
        b.append(this.requiredValueDefinition);
        b.append(", ");
        b.append("settingValueTemplateId=");
        b.append(this.settingValueTemplateId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
