package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Choice Setting Value Definition Template”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "allowedOptions"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationChoiceSettingValueDefinitionTemplate implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("allowedOptions")
    protected List<DeviceManagementConfigurationOptionDefinitionTemplate> allowedOptions;

    @JsonProperty("allowedOptions@nextLink")
    protected String allowedOptionsNextLink;

    protected DeviceManagementConfigurationChoiceSettingValueDefinitionTemplate() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationChoiceSettingValueDefinitionTemplate";
    }

    /**
     * <i>“Choice Setting Allowed Options”</i>
     * 
     * @return property allowedOptions
     */
    @Property(name="allowedOptions")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationOptionDefinitionTemplate> getAllowedOptions() {
        return new CollectionPage<DeviceManagementConfigurationOptionDefinitionTemplate>(contextPath, DeviceManagementConfigurationOptionDefinitionTemplate.class, this.allowedOptions, Optional.ofNullable(allowedOptionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Choice Setting Allowed Options”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property allowedOptions
     */
    @Property(name="allowedOptions")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationOptionDefinitionTemplate> getAllowedOptions(HttpRequestOptions options) {
        return new CollectionPage<DeviceManagementConfigurationOptionDefinitionTemplate>(contextPath, DeviceManagementConfigurationOptionDefinitionTemplate.class, this.allowedOptions, Optional.ofNullable(allowedOptionsNextLink), Collections.emptyList(), options);
    }

    public DeviceManagementConfigurationChoiceSettingValueDefinitionTemplate withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationChoiceSettingValueDefinitionTemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<DeviceManagementConfigurationOptionDefinitionTemplate> allowedOptions;
        private String allowedOptionsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Choice Setting Allowed Options”</i>
         * 
         * @param allowedOptions
         *            value of {@code allowedOptions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedOptions(List<DeviceManagementConfigurationOptionDefinitionTemplate> allowedOptions) {
            this.allowedOptions = allowedOptions;
            this.changedFields = changedFields.add("allowedOptions");
            return this;
        }

        /**
         * <i>“Choice Setting Allowed Options”</i>
         * 
         * @param allowedOptions
         *            value of {@code allowedOptions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedOptions(DeviceManagementConfigurationOptionDefinitionTemplate... allowedOptions) {
            return allowedOptions(Arrays.asList(allowedOptions));
        }

        /**
         * <i>“Choice Setting Allowed Options”</i>
         * 
         * @param allowedOptionsNextLink
         *            value of {@code allowedOptions@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedOptionsNextLink(String allowedOptionsNextLink) {
            this.allowedOptionsNextLink = allowedOptionsNextLink;
            this.changedFields = changedFields.add("allowedOptions");
            return this;
        }

        public DeviceManagementConfigurationChoiceSettingValueDefinitionTemplate build() {
            DeviceManagementConfigurationChoiceSettingValueDefinitionTemplate _x = new DeviceManagementConfigurationChoiceSettingValueDefinitionTemplate();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationChoiceSettingValueDefinitionTemplate";
            _x.allowedOptions = allowedOptions;
            _x.allowedOptionsNextLink = allowedOptionsNextLink;
            return _x;
        }
    }

    private DeviceManagementConfigurationChoiceSettingValueDefinitionTemplate _copy() {
        DeviceManagementConfigurationChoiceSettingValueDefinitionTemplate _x = new DeviceManagementConfigurationChoiceSettingValueDefinitionTemplate();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.allowedOptions = allowedOptions;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationChoiceSettingValueDefinitionTemplate[");
        b.append("allowedOptions=");
        b.append(this.allowedOptions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
