package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Setting value”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "children", 
    "value"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationChoiceSettingValue extends DeviceManagementConfigurationSettingValue implements ODataType {

    @JsonProperty("children")
    protected List<DeviceManagementConfigurationSettingInstance> children;

    @JsonProperty("children@nextLink")
    protected String childrenNextLink;

    @JsonProperty("value")
    protected String value;

    protected DeviceManagementConfigurationChoiceSettingValue() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationChoiceSettingValue";
    }

    /**
     * <i>“Child settings.”</i>
     * 
     * @return property children
     */
    @Property(name="children")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationSettingInstance> getChildren() {
        return new CollectionPage<DeviceManagementConfigurationSettingInstance>(contextPath, DeviceManagementConfigurationSettingInstance.class, this.children, Optional.ofNullable(childrenNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Child settings.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property children
     */
    @Property(name="children")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationSettingInstance> getChildren(HttpRequestOptions options) {
        return new CollectionPage<DeviceManagementConfigurationSettingInstance>(contextPath, DeviceManagementConfigurationSettingInstance.class, this.children, Optional.ofNullable(childrenNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Choice setting value: an OptionDefinition ItemId.”</i>
     * 
     * @return property value
     */
    @Property(name="value")
    @JsonIgnore
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code value} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Choice setting value: an OptionDefinition ItemId.”</i>
     * 
     * @param value
     *            new value of {@code value} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code value} field changed
     */
    public DeviceManagementConfigurationChoiceSettingValue withValue(String value) {
        DeviceManagementConfigurationChoiceSettingValue _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationChoiceSettingValue");
        _x.value = value;
        return _x;
    }

    public DeviceManagementConfigurationChoiceSettingValue withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationChoiceSettingValue _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementConfigurationChoiceSettingValue() {
        return new Builder();
    }

    public static final class Builder {
        private DeviceManagementConfigurationSettingValueTemplateReference settingValueTemplateReference;
        private List<DeviceManagementConfigurationSettingInstance> children;
        private String childrenNextLink;
        private String value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder settingValueTemplateReference(DeviceManagementConfigurationSettingValueTemplateReference settingValueTemplateReference) {
            this.settingValueTemplateReference = settingValueTemplateReference;
            this.changedFields = changedFields.add("settingValueTemplateReference");
            return this;
        }

        /**
         * <i>“Child settings.”</i>
         * 
         * @param children
         *            value of {@code children} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder children(List<DeviceManagementConfigurationSettingInstance> children) {
            this.children = children;
            this.changedFields = changedFields.add("children");
            return this;
        }

        /**
         * <i>“Child settings.”</i>
         * 
         * @param children
         *            value of {@code children} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder children(DeviceManagementConfigurationSettingInstance... children) {
            return children(Arrays.asList(children));
        }

        /**
         * <i>“Child settings.”</i>
         * 
         * @param childrenNextLink
         *            value of {@code children@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder childrenNextLink(String childrenNextLink) {
            this.childrenNextLink = childrenNextLink;
            this.changedFields = changedFields.add("children");
            return this;
        }

        /**
         * <i>“Choice setting value: an OptionDefinition ItemId.”</i>
         * 
         * @param value
         *            value of {@code value} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder value(String value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public DeviceManagementConfigurationChoiceSettingValue build() {
            DeviceManagementConfigurationChoiceSettingValue _x = new DeviceManagementConfigurationChoiceSettingValue();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationChoiceSettingValue";
            _x.settingValueTemplateReference = settingValueTemplateReference;
            _x.children = children;
            _x.childrenNextLink = childrenNextLink;
            _x.value = value;
            return _x;
        }
    }

    private DeviceManagementConfigurationChoiceSettingValue _copy() {
        DeviceManagementConfigurationChoiceSettingValue _x = new DeviceManagementConfigurationChoiceSettingValue();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.settingValueTemplateReference = settingValueTemplateReference;
        _x.children = children;
        _x.value = value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationChoiceSettingValue[");
        b.append("settingValueTemplateReference=");
        b.append(this.settingValueTemplateReference);
        b.append(", ");
        b.append("children=");
        b.append(this.children);
        b.append(", ");
        b.append("value=");
        b.append(this.value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
