package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Setting instance within policy”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "choiceSettingValue"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationChoiceSettingInstance extends DeviceManagementConfigurationSettingInstance implements ODataType {

    @JsonProperty("choiceSettingValue")
    protected DeviceManagementConfigurationChoiceSettingValue choiceSettingValue;

    protected DeviceManagementConfigurationChoiceSettingInstance() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationChoiceSettingInstance";
    }

    /**
     * <i>“Choice setting value”</i>
     * 
     * @return property choiceSettingValue
     */
    @Property(name="choiceSettingValue")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationChoiceSettingValue> getChoiceSettingValue() {
        return Optional.ofNullable(choiceSettingValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * choiceSettingValue} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Choice setting value”</i>
     * 
     * @param choiceSettingValue
     *            new value of {@code choiceSettingValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code choiceSettingValue} field changed
     */
    public DeviceManagementConfigurationChoiceSettingInstance withChoiceSettingValue(DeviceManagementConfigurationChoiceSettingValue choiceSettingValue) {
        DeviceManagementConfigurationChoiceSettingInstance _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationChoiceSettingInstance");
        _x.choiceSettingValue = choiceSettingValue;
        return _x;
    }

    public DeviceManagementConfigurationChoiceSettingInstance withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationChoiceSettingInstance _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementConfigurationChoiceSettingInstance() {
        return new Builder();
    }

    public static final class Builder {
        private String settingDefinitionId;
        private DeviceManagementConfigurationSettingInstanceTemplateReference settingInstanceTemplateReference;
        private DeviceManagementConfigurationChoiceSettingValue choiceSettingValue;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder settingDefinitionId(String settingDefinitionId) {
            this.settingDefinitionId = settingDefinitionId;
            this.changedFields = changedFields.add("settingDefinitionId");
            return this;
        }

        public Builder settingInstanceTemplateReference(DeviceManagementConfigurationSettingInstanceTemplateReference settingInstanceTemplateReference) {
            this.settingInstanceTemplateReference = settingInstanceTemplateReference;
            this.changedFields = changedFields.add("settingInstanceTemplateReference");
            return this;
        }

        /**
         * <i>“Choice setting value”</i>
         * 
         * @param choiceSettingValue
         *            value of {@code choiceSettingValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder choiceSettingValue(DeviceManagementConfigurationChoiceSettingValue choiceSettingValue) {
            this.choiceSettingValue = choiceSettingValue;
            this.changedFields = changedFields.add("choiceSettingValue");
            return this;
        }

        public DeviceManagementConfigurationChoiceSettingInstance build() {
            DeviceManagementConfigurationChoiceSettingInstance _x = new DeviceManagementConfigurationChoiceSettingInstance();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationChoiceSettingInstance";
            _x.settingDefinitionId = settingDefinitionId;
            _x.settingInstanceTemplateReference = settingInstanceTemplateReference;
            _x.choiceSettingValue = choiceSettingValue;
            return _x;
        }
    }

    private DeviceManagementConfigurationChoiceSettingInstance _copy() {
        DeviceManagementConfigurationChoiceSettingInstance _x = new DeviceManagementConfigurationChoiceSettingInstance();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.settingDefinitionId = settingDefinitionId;
        _x.settingInstanceTemplateReference = settingInstanceTemplateReference;
        _x.choiceSettingValue = choiceSettingValue;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationChoiceSettingInstance[");
        b.append("settingDefinitionId=");
        b.append(this.settingDefinitionId);
        b.append(", ");
        b.append("settingInstanceTemplateReference=");
        b.append(this.settingInstanceTemplateReference);
        b.append(", ");
        b.append("choiceSettingValue=");
        b.append(this.choiceSettingValue);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
