package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "deviceId", 
    "keyMaterial", 
    "keyType"})
@JsonInclude(Include.NON_NULL)
public class DeviceKey implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("deviceId")
    protected UUID deviceId;

    @JsonProperty("keyMaterial")
    protected byte[] keyMaterial;

    @JsonProperty("keyType")
    protected String keyType;

    protected DeviceKey() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceKey";
    }

    @Property(name="deviceId")
    @JsonIgnore
    public Optional<UUID> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    public DeviceKey withDeviceId(UUID deviceId) {
        DeviceKey _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceKey");
        _x.deviceId = deviceId;
        return _x;
    }

    @Property(name="keyMaterial")
    @JsonIgnore
    public Optional<byte[]> getKeyMaterial() {
        return Optional.ofNullable(keyMaterial);
    }

    public DeviceKey withKeyMaterial(byte[] keyMaterial) {
        DeviceKey _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceKey");
        _x.keyMaterial = keyMaterial;
        return _x;
    }

    @Property(name="keyType")
    @JsonIgnore
    public Optional<String> getKeyType() {
        return Optional.ofNullable(keyType);
    }

    public DeviceKey withKeyType(String keyType) {
        DeviceKey _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceKey");
        _x.keyType = keyType;
        return _x;
    }

    public DeviceKey withUnmappedField(String name, Object value) {
        DeviceKey _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private UUID deviceId;
        private byte[] keyMaterial;
        private String keyType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder deviceId(UUID deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        public Builder keyMaterial(byte[] keyMaterial) {
            this.keyMaterial = keyMaterial;
            this.changedFields = changedFields.add("keyMaterial");
            return this;
        }

        public Builder keyType(String keyType) {
            this.keyType = keyType;
            this.changedFields = changedFields.add("keyType");
            return this;
        }

        public DeviceKey build() {
            DeviceKey _x = new DeviceKey();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceKey";
            _x.deviceId = deviceId;
            _x.keyMaterial = keyMaterial;
            _x.keyType = keyType;
            return _x;
        }
    }

    private DeviceKey _copy() {
        DeviceKey _x = new DeviceKey();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.deviceId = deviceId;
        _x.keyMaterial = keyMaterial;
        _x.keyType = keyType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceKey[");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("keyMaterial=");
        b.append(this.keyMaterial);
        b.append(", ");
        b.append("keyType=");
        b.append(this.keyType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
