package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Base type of Device health script run schedule.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "interval"})
@JsonInclude(Include.NON_NULL)
public class DeviceHealthScriptRunSchedule implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("interval")
    protected Integer interval;

    protected DeviceHealthScriptRunSchedule() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceHealthScriptRunSchedule";
    }

    /**
     * <i>“The x value of every x hours for hourly schedule, every x days for Daily
     * Schedule, every x weeks for weekly schedule, every x months for Monthly Schedule
     * . Valid values 1 to 23”</i>
     * 
     * @return property interval
     */
    @Property(name="interval")
    @JsonIgnore
    public Optional<Integer> getInterval() {
        return Optional.ofNullable(interval);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code interval} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The x value of every x hours for hourly schedule, every x days for Daily
     * Schedule, every x weeks for weekly schedule, every x months for Monthly Schedule
     * . Valid values 1 to 23”</i>
     * 
     * @param interval
     *            new value of {@code interval} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code interval} field changed
     */
    public DeviceHealthScriptRunSchedule withInterval(Integer interval) {
        DeviceHealthScriptRunSchedule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptRunSchedule");
        _x.interval = interval;
        return _x;
    }

    public DeviceHealthScriptRunSchedule withUnmappedField(String name, Object value) {
        DeviceHealthScriptRunSchedule _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    private DeviceHealthScriptRunSchedule _copy() {
        DeviceHealthScriptRunSchedule _x = new DeviceHealthScriptRunSchedule();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.interval = interval;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceHealthScriptRunSchedule[");
        b.append("interval=");
        b.append(this.interval);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
