package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Double;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“Device location”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "altitude", 
    "heading", 
    "horizontalAccuracy", 
    "lastCollectedDateTime", 
    "lastCollectedDateTimeUtc", 
    "latitude", 
    "longitude", 
    "speed", 
    "verticalAccuracy"})
@JsonInclude(Include.NON_NULL)
public class DeviceGeoLocation implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("altitude")
    protected Double altitude;

    @JsonProperty("heading")
    protected Double heading;

    @JsonProperty("horizontalAccuracy")
    protected Double horizontalAccuracy;

    @JsonProperty("lastCollectedDateTime")
    protected OffsetDateTime lastCollectedDateTime;

    @JsonProperty("lastCollectedDateTimeUtc")
    protected OffsetDateTime lastCollectedDateTimeUtc;

    @JsonProperty("latitude")
    protected Double latitude;

    @JsonProperty("longitude")
    protected Double longitude;

    @JsonProperty("speed")
    protected Double speed;

    @JsonProperty("verticalAccuracy")
    protected Double verticalAccuracy;

    protected DeviceGeoLocation() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceGeoLocation";
    }

    /**
     * <i>“Altitude, given in meters above sea level”</i>
     * 
     * @return property altitude
     */
    @Property(name="altitude")
    @JsonIgnore
    public Optional<Double> getAltitude() {
        return Optional.ofNullable(altitude);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code altitude} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Altitude, given in meters above sea level”</i>
     * 
     * @param altitude
     *            new value of {@code altitude} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code altitude} field changed
     */
    public DeviceGeoLocation withAltitude(Double altitude) {
        DeviceGeoLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceGeoLocation");
        _x.altitude = altitude;
        return _x;
    }

    /**
     * <i>“Heading in degrees from true north”</i>
     * 
     * @return property heading
     */
    @Property(name="heading")
    @JsonIgnore
    public Optional<Double> getHeading() {
        return Optional.ofNullable(heading);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code heading} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Heading in degrees from true north”</i>
     * 
     * @param heading
     *            new value of {@code heading} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code heading} field changed
     */
    public DeviceGeoLocation withHeading(Double heading) {
        DeviceGeoLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceGeoLocation");
        _x.heading = heading;
        return _x;
    }

    /**
     * <i>“Accuracy of longitude and latitude in meters”</i>
     * 
     * @return property horizontalAccuracy
     */
    @Property(name="horizontalAccuracy")
    @JsonIgnore
    public Optional<Double> getHorizontalAccuracy() {
        return Optional.ofNullable(horizontalAccuracy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * horizontalAccuracy} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Accuracy of longitude and latitude in meters”</i>
     * 
     * @param horizontalAccuracy
     *            new value of {@code horizontalAccuracy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code horizontalAccuracy} field changed
     */
    public DeviceGeoLocation withHorizontalAccuracy(Double horizontalAccuracy) {
        DeviceGeoLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceGeoLocation");
        _x.horizontalAccuracy = horizontalAccuracy;
        return _x;
    }

    /**
     * <i>“Time at which location was recorded, relative to UTC”</i>
     * 
     * @return property lastCollectedDateTime
     */
    @Property(name="lastCollectedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastCollectedDateTime() {
        return Optional.ofNullable(lastCollectedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastCollectedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Time at which location was recorded, relative to UTC”</i>
     * 
     * @param lastCollectedDateTime
     *            new value of {@code lastCollectedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastCollectedDateTime} field changed
     */
    public DeviceGeoLocation withLastCollectedDateTime(OffsetDateTime lastCollectedDateTime) {
        DeviceGeoLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceGeoLocation");
        _x.lastCollectedDateTime = lastCollectedDateTime;
        return _x;
    }

    /**
     * <i>“Time at which location was recorded, relative to UTC”</i>
     * 
     * @return property lastCollectedDateTimeUtc
     */
    @Property(name="lastCollectedDateTimeUtc")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastCollectedDateTimeUtc() {
        return Optional.ofNullable(lastCollectedDateTimeUtc);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastCollectedDateTimeUtc} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Time at which location was recorded, relative to UTC”</i>
     * 
     * @param lastCollectedDateTimeUtc
     *            new value of {@code lastCollectedDateTimeUtc} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastCollectedDateTimeUtc} field changed
     */
    public DeviceGeoLocation withLastCollectedDateTimeUtc(OffsetDateTime lastCollectedDateTimeUtc) {
        DeviceGeoLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceGeoLocation");
        _x.lastCollectedDateTimeUtc = lastCollectedDateTimeUtc;
        return _x;
    }

    /**
     * <i>“Latitude coordinate of the device's location”</i>
     * 
     * @return property latitude
     */
    @Property(name="latitude")
    @JsonIgnore
    public Optional<Double> getLatitude() {
        return Optional.ofNullable(latitude);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code latitude} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Latitude coordinate of the device's location”</i>
     * 
     * @param latitude
     *            new value of {@code latitude} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code latitude} field changed
     */
    public DeviceGeoLocation withLatitude(Double latitude) {
        DeviceGeoLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceGeoLocation");
        _x.latitude = latitude;
        return _x;
    }

    /**
     * <i>“Longitude coordinate of the device's location”</i>
     * 
     * @return property longitude
     */
    @Property(name="longitude")
    @JsonIgnore
    public Optional<Double> getLongitude() {
        return Optional.ofNullable(longitude);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code longitude} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Longitude coordinate of the device's location”</i>
     * 
     * @param longitude
     *            new value of {@code longitude} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code longitude} field changed
     */
    public DeviceGeoLocation withLongitude(Double longitude) {
        DeviceGeoLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceGeoLocation");
        _x.longitude = longitude;
        return _x;
    }

    /**
     * <i>“Speed the device is traveling in meters per second”</i>
     * 
     * @return property speed
     */
    @Property(name="speed")
    @JsonIgnore
    public Optional<Double> getSpeed() {
        return Optional.ofNullable(speed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code speed} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Speed the device is traveling in meters per second”</i>
     * 
     * @param speed
     *            new value of {@code speed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code speed} field changed
     */
    public DeviceGeoLocation withSpeed(Double speed) {
        DeviceGeoLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceGeoLocation");
        _x.speed = speed;
        return _x;
    }

    /**
     * <i>“Accuracy of altitude in meters”</i>
     * 
     * @return property verticalAccuracy
     */
    @Property(name="verticalAccuracy")
    @JsonIgnore
    public Optional<Double> getVerticalAccuracy() {
        return Optional.ofNullable(verticalAccuracy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code verticalAccuracy}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Accuracy of altitude in meters”</i>
     * 
     * @param verticalAccuracy
     *            new value of {@code verticalAccuracy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code verticalAccuracy} field changed
     */
    public DeviceGeoLocation withVerticalAccuracy(Double verticalAccuracy) {
        DeviceGeoLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceGeoLocation");
        _x.verticalAccuracy = verticalAccuracy;
        return _x;
    }

    public DeviceGeoLocation withUnmappedField(String name, Object value) {
        DeviceGeoLocation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Double altitude;
        private Double heading;
        private Double horizontalAccuracy;
        private OffsetDateTime lastCollectedDateTime;
        private OffsetDateTime lastCollectedDateTimeUtc;
        private Double latitude;
        private Double longitude;
        private Double speed;
        private Double verticalAccuracy;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Altitude, given in meters above sea level”</i>
         * 
         * @param altitude
         *            value of {@code altitude} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder altitude(Double altitude) {
            this.altitude = altitude;
            this.changedFields = changedFields.add("altitude");
            return this;
        }

        /**
         * <i>“Heading in degrees from true north”</i>
         * 
         * @param heading
         *            value of {@code heading} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder heading(Double heading) {
            this.heading = heading;
            this.changedFields = changedFields.add("heading");
            return this;
        }

        /**
         * <i>“Accuracy of longitude and latitude in meters”</i>
         * 
         * @param horizontalAccuracy
         *            value of {@code horizontalAccuracy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder horizontalAccuracy(Double horizontalAccuracy) {
            this.horizontalAccuracy = horizontalAccuracy;
            this.changedFields = changedFields.add("horizontalAccuracy");
            return this;
        }

        /**
         * <i>“Time at which location was recorded, relative to UTC”</i>
         * 
         * @param lastCollectedDateTime
         *            value of {@code lastCollectedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastCollectedDateTime(OffsetDateTime lastCollectedDateTime) {
            this.lastCollectedDateTime = lastCollectedDateTime;
            this.changedFields = changedFields.add("lastCollectedDateTime");
            return this;
        }

        /**
         * <i>“Time at which location was recorded, relative to UTC”</i>
         * 
         * @param lastCollectedDateTimeUtc
         *            value of {@code lastCollectedDateTimeUtc} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastCollectedDateTimeUtc(OffsetDateTime lastCollectedDateTimeUtc) {
            this.lastCollectedDateTimeUtc = lastCollectedDateTimeUtc;
            this.changedFields = changedFields.add("lastCollectedDateTimeUtc");
            return this;
        }

        /**
         * <i>“Latitude coordinate of the device's location”</i>
         * 
         * @param latitude
         *            value of {@code latitude} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder latitude(Double latitude) {
            this.latitude = latitude;
            this.changedFields = changedFields.add("latitude");
            return this;
        }

        /**
         * <i>“Longitude coordinate of the device's location”</i>
         * 
         * @param longitude
         *            value of {@code longitude} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder longitude(Double longitude) {
            this.longitude = longitude;
            this.changedFields = changedFields.add("longitude");
            return this;
        }

        /**
         * <i>“Speed the device is traveling in meters per second”</i>
         * 
         * @param speed
         *            value of {@code speed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder speed(Double speed) {
            this.speed = speed;
            this.changedFields = changedFields.add("speed");
            return this;
        }

        /**
         * <i>“Accuracy of altitude in meters”</i>
         * 
         * @param verticalAccuracy
         *            value of {@code verticalAccuracy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder verticalAccuracy(Double verticalAccuracy) {
            this.verticalAccuracy = verticalAccuracy;
            this.changedFields = changedFields.add("verticalAccuracy");
            return this;
        }

        public DeviceGeoLocation build() {
            DeviceGeoLocation _x = new DeviceGeoLocation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceGeoLocation";
            _x.altitude = altitude;
            _x.heading = heading;
            _x.horizontalAccuracy = horizontalAccuracy;
            _x.lastCollectedDateTime = lastCollectedDateTime;
            _x.lastCollectedDateTimeUtc = lastCollectedDateTimeUtc;
            _x.latitude = latitude;
            _x.longitude = longitude;
            _x.speed = speed;
            _x.verticalAccuracy = verticalAccuracy;
            return _x;
        }
    }

    private DeviceGeoLocation _copy() {
        DeviceGeoLocation _x = new DeviceGeoLocation();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.altitude = altitude;
        _x.heading = heading;
        _x.horizontalAccuracy = horizontalAccuracy;
        _x.lastCollectedDateTime = lastCollectedDateTime;
        _x.lastCollectedDateTimeUtc = lastCollectedDateTimeUtc;
        _x.latitude = latitude;
        _x.longitude = longitude;
        _x.speed = speed;
        _x.verticalAccuracy = verticalAccuracy;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceGeoLocation[");
        b.append("altitude=");
        b.append(this.altitude);
        b.append(", ");
        b.append("heading=");
        b.append(this.heading);
        b.append(", ");
        b.append("horizontalAccuracy=");
        b.append(this.horizontalAccuracy);
        b.append(", ");
        b.append("lastCollectedDateTime=");
        b.append(this.lastCollectedDateTime);
        b.append(", ");
        b.append("lastCollectedDateTimeUtc=");
        b.append(this.lastCollectedDateTimeUtc);
        b.append(", ");
        b.append("latitude=");
        b.append(this.latitude);
        b.append(", ");
        b.append("longitude=");
        b.append(this.longitude);
        b.append(", ");
        b.append("speed=");
        b.append(this.speed);
        b.append(", ");
        b.append("verticalAccuracy=");
        b.append(this.verticalAccuracy);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
