package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Platform specific enrollment restrictions”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "blockedManufacturers", 
    "blockedSkus", 
    "osMaximumVersion", 
    "osMinimumVersion", 
    "personalDeviceEnrollmentBlocked", 
    "platformBlocked"})
@JsonInclude(Include.NON_NULL)
public class DeviceEnrollmentPlatformRestriction implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("blockedManufacturers")
    protected List<String> blockedManufacturers;

    @JsonProperty("blockedManufacturers@nextLink")
    protected String blockedManufacturersNextLink;

    @JsonProperty("blockedSkus")
    protected List<String> blockedSkus;

    @JsonProperty("blockedSkus@nextLink")
    protected String blockedSkusNextLink;

    @JsonProperty("osMaximumVersion")
    protected String osMaximumVersion;

    @JsonProperty("osMinimumVersion")
    protected String osMinimumVersion;

    @JsonProperty("personalDeviceEnrollmentBlocked")
    protected Boolean personalDeviceEnrollmentBlocked;

    @JsonProperty("platformBlocked")
    protected Boolean platformBlocked;

    protected DeviceEnrollmentPlatformRestriction() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceEnrollmentPlatformRestriction";
    }

    /**
     * <i>“Collection of blocked Manufacturers.”</i>
     * 
     * @return property blockedManufacturers
     */
    @Property(name="blockedManufacturers")
    @JsonIgnore
    public CollectionPage<String> getBlockedManufacturers() {
        return new CollectionPage<String>(contextPath, String.class, this.blockedManufacturers, Optional.ofNullable(blockedManufacturersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Collection of blocked Manufacturers.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property blockedManufacturers
     */
    @Property(name="blockedManufacturers")
    @JsonIgnore
    public CollectionPage<String> getBlockedManufacturers(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.blockedManufacturers, Optional.ofNullable(blockedManufacturersNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Collection of blocked Skus.”</i>
     * 
     * @return property blockedSkus
     */
    @Property(name="blockedSkus")
    @JsonIgnore
    public CollectionPage<String> getBlockedSkus() {
        return new CollectionPage<String>(contextPath, String.class, this.blockedSkus, Optional.ofNullable(blockedSkusNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Collection of blocked Skus.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property blockedSkus
     */
    @Property(name="blockedSkus")
    @JsonIgnore
    public CollectionPage<String> getBlockedSkus(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.blockedSkus, Optional.ofNullable(blockedSkusNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Max OS version supported”</i>
     * 
     * @return property osMaximumVersion
     */
    @Property(name="osMaximumVersion")
    @JsonIgnore
    public Optional<String> getOsMaximumVersion() {
        return Optional.ofNullable(osMaximumVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osMaximumVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Max OS version supported”</i>
     * 
     * @param osMaximumVersion
     *            new value of {@code osMaximumVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osMaximumVersion} field changed
     */
    public DeviceEnrollmentPlatformRestriction withOsMaximumVersion(String osMaximumVersion) {
        DeviceEnrollmentPlatformRestriction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentPlatformRestriction");
        _x.osMaximumVersion = osMaximumVersion;
        return _x;
    }

    /**
     * <i>“Min OS version supported”</i>
     * 
     * @return property osMinimumVersion
     */
    @Property(name="osMinimumVersion")
    @JsonIgnore
    public Optional<String> getOsMinimumVersion() {
        return Optional.ofNullable(osMinimumVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osMinimumVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Min OS version supported”</i>
     * 
     * @param osMinimumVersion
     *            new value of {@code osMinimumVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osMinimumVersion} field changed
     */
    public DeviceEnrollmentPlatformRestriction withOsMinimumVersion(String osMinimumVersion) {
        DeviceEnrollmentPlatformRestriction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentPlatformRestriction");
        _x.osMinimumVersion = osMinimumVersion;
        return _x;
    }

    /**
     * <i>“Block personally owned devices from enrolling”</i>
     * 
     * @return property personalDeviceEnrollmentBlocked
     */
    @Property(name="personalDeviceEnrollmentBlocked")
    @JsonIgnore
    public Optional<Boolean> getPersonalDeviceEnrollmentBlocked() {
        return Optional.ofNullable(personalDeviceEnrollmentBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * personalDeviceEnrollmentBlocked} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Block personally owned devices from enrolling”</i>
     * 
     * @param personalDeviceEnrollmentBlocked
     *            new value of {@code personalDeviceEnrollmentBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code personalDeviceEnrollmentBlocked} field changed
     */
    public DeviceEnrollmentPlatformRestriction withPersonalDeviceEnrollmentBlocked(Boolean personalDeviceEnrollmentBlocked) {
        DeviceEnrollmentPlatformRestriction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentPlatformRestriction");
        _x.personalDeviceEnrollmentBlocked = personalDeviceEnrollmentBlocked;
        return _x;
    }

    /**
     * <i>“Block the platform from enrolling”</i>
     * 
     * @return property platformBlocked
     */
    @Property(name="platformBlocked")
    @JsonIgnore
    public Optional<Boolean> getPlatformBlocked() {
        return Optional.ofNullable(platformBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code platformBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Block the platform from enrolling”</i>
     * 
     * @param platformBlocked
     *            new value of {@code platformBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code platformBlocked} field changed
     */
    public DeviceEnrollmentPlatformRestriction withPlatformBlocked(Boolean platformBlocked) {
        DeviceEnrollmentPlatformRestriction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentPlatformRestriction");
        _x.platformBlocked = platformBlocked;
        return _x;
    }

    public DeviceEnrollmentPlatformRestriction withUnmappedField(String name, Object value) {
        DeviceEnrollmentPlatformRestriction _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> blockedManufacturers;
        private String blockedManufacturersNextLink;
        private List<String> blockedSkus;
        private String blockedSkusNextLink;
        private String osMaximumVersion;
        private String osMinimumVersion;
        private Boolean personalDeviceEnrollmentBlocked;
        private Boolean platformBlocked;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Collection of blocked Manufacturers.”</i>
         * 
         * @param blockedManufacturers
         *            value of {@code blockedManufacturers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockedManufacturers(List<String> blockedManufacturers) {
            this.blockedManufacturers = blockedManufacturers;
            this.changedFields = changedFields.add("blockedManufacturers");
            return this;
        }

        /**
         * <i>“Collection of blocked Manufacturers.”</i>
         * 
         * @param blockedManufacturers
         *            value of {@code blockedManufacturers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockedManufacturers(String... blockedManufacturers) {
            return blockedManufacturers(Arrays.asList(blockedManufacturers));
        }

        /**
         * <i>“Collection of blocked Manufacturers.”</i>
         * 
         * @param blockedManufacturersNextLink
         *            value of {@code blockedManufacturers@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockedManufacturersNextLink(String blockedManufacturersNextLink) {
            this.blockedManufacturersNextLink = blockedManufacturersNextLink;
            this.changedFields = changedFields.add("blockedManufacturers");
            return this;
        }

        /**
         * <i>“Collection of blocked Skus.”</i>
         * 
         * @param blockedSkus
         *            value of {@code blockedSkus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockedSkus(List<String> blockedSkus) {
            this.blockedSkus = blockedSkus;
            this.changedFields = changedFields.add("blockedSkus");
            return this;
        }

        /**
         * <i>“Collection of blocked Skus.”</i>
         * 
         * @param blockedSkus
         *            value of {@code blockedSkus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockedSkus(String... blockedSkus) {
            return blockedSkus(Arrays.asList(blockedSkus));
        }

        /**
         * <i>“Collection of blocked Skus.”</i>
         * 
         * @param blockedSkusNextLink
         *            value of {@code blockedSkus@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockedSkusNextLink(String blockedSkusNextLink) {
            this.blockedSkusNextLink = blockedSkusNextLink;
            this.changedFields = changedFields.add("blockedSkus");
            return this;
        }

        /**
         * <i>“Max OS version supported”</i>
         * 
         * @param osMaximumVersion
         *            value of {@code osMaximumVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osMaximumVersion(String osMaximumVersion) {
            this.osMaximumVersion = osMaximumVersion;
            this.changedFields = changedFields.add("osMaximumVersion");
            return this;
        }

        /**
         * <i>“Min OS version supported”</i>
         * 
         * @param osMinimumVersion
         *            value of {@code osMinimumVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osMinimumVersion(String osMinimumVersion) {
            this.osMinimumVersion = osMinimumVersion;
            this.changedFields = changedFields.add("osMinimumVersion");
            return this;
        }

        /**
         * <i>“Block personally owned devices from enrolling”</i>
         * 
         * @param personalDeviceEnrollmentBlocked
         *            value of {@code personalDeviceEnrollmentBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder personalDeviceEnrollmentBlocked(Boolean personalDeviceEnrollmentBlocked) {
            this.personalDeviceEnrollmentBlocked = personalDeviceEnrollmentBlocked;
            this.changedFields = changedFields.add("personalDeviceEnrollmentBlocked");
            return this;
        }

        /**
         * <i>“Block the platform from enrolling”</i>
         * 
         * @param platformBlocked
         *            value of {@code platformBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder platformBlocked(Boolean platformBlocked) {
            this.platformBlocked = platformBlocked;
            this.changedFields = changedFields.add("platformBlocked");
            return this;
        }

        public DeviceEnrollmentPlatformRestriction build() {
            DeviceEnrollmentPlatformRestriction _x = new DeviceEnrollmentPlatformRestriction();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceEnrollmentPlatformRestriction";
            _x.blockedManufacturers = blockedManufacturers;
            _x.blockedManufacturersNextLink = blockedManufacturersNextLink;
            _x.blockedSkus = blockedSkus;
            _x.blockedSkusNextLink = blockedSkusNextLink;
            _x.osMaximumVersion = osMaximumVersion;
            _x.osMinimumVersion = osMinimumVersion;
            _x.personalDeviceEnrollmentBlocked = personalDeviceEnrollmentBlocked;
            _x.platformBlocked = platformBlocked;
            return _x;
        }
    }

    private DeviceEnrollmentPlatformRestriction _copy() {
        DeviceEnrollmentPlatformRestriction _x = new DeviceEnrollmentPlatformRestriction();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.blockedManufacturers = blockedManufacturers;
        _x.blockedSkus = blockedSkus;
        _x.osMaximumVersion = osMaximumVersion;
        _x.osMinimumVersion = osMinimumVersion;
        _x.personalDeviceEnrollmentBlocked = personalDeviceEnrollmentBlocked;
        _x.platformBlocked = platformBlocked;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceEnrollmentPlatformRestriction[");
        b.append("blockedManufacturers=");
        b.append(this.blockedManufacturers);
        b.append(", ");
        b.append("blockedSkus=");
        b.append(this.blockedSkus);
        b.append(", ");
        b.append("osMaximumVersion=");
        b.append(this.osMaximumVersion);
        b.append(", ");
        b.append("osMinimumVersion=");
        b.append(this.osMinimumVersion);
        b.append(", ");
        b.append("personalDeviceEnrollmentBlocked=");
        b.append(this.personalDeviceEnrollmentBlocked);
        b.append(", ");
        b.append("platformBlocked=");
        b.append(this.platformBlocked);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
