package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“Conflict summary for a set of device configuration policies.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceId", 
    "deviceName", 
    "lastCheckinDateTime", 
    "userDisplayName", 
    "userId", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class DeviceConfigurationTargetedUserAndDevice implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("deviceId")
    protected String deviceId;

    @JsonProperty("deviceName")
    protected String deviceName;

    @JsonProperty("lastCheckinDateTime")
    protected OffsetDateTime lastCheckinDateTime;

    @JsonProperty("userDisplayName")
    protected String userDisplayName;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected DeviceConfigurationTargetedUserAndDevice() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceConfigurationTargetedUserAndDevice";
    }

    /**
     * <i>“The id of the device in the checkin.”</i>
     * 
     * @return property deviceId
     */
    @Property(name="deviceId")
    @JsonIgnore
    public Optional<String> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The id of the device in the checkin.”</i>
     * 
     * @param deviceId
     *            new value of {@code deviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceId} field changed
     */
    public DeviceConfigurationTargetedUserAndDevice withDeviceId(String deviceId) {
        DeviceConfigurationTargetedUserAndDevice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfigurationTargetedUserAndDevice");
        _x.deviceId = deviceId;
        return _x;
    }

    /**
     * <i>“The name of the device in the checkin.”</i>
     * 
     * @return property deviceName
     */
    @Property(name="deviceName")
    @JsonIgnore
    public Optional<String> getDeviceName() {
        return Optional.ofNullable(deviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The name of the device in the checkin.”</i>
     * 
     * @param deviceName
     *            new value of {@code deviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceName} field changed
     */
    public DeviceConfigurationTargetedUserAndDevice withDeviceName(String deviceName) {
        DeviceConfigurationTargetedUserAndDevice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfigurationTargetedUserAndDevice");
        _x.deviceName = deviceName;
        return _x;
    }

    /**
     * <i>“Last checkin time for this user/device pair.”</i>
     * 
     * @return property lastCheckinDateTime
     */
    @Property(name="lastCheckinDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastCheckinDateTime() {
        return Optional.ofNullable(lastCheckinDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastCheckinDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Last checkin time for this user/device pair.”</i>
     * 
     * @param lastCheckinDateTime
     *            new value of {@code lastCheckinDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastCheckinDateTime} field changed
     */
    public DeviceConfigurationTargetedUserAndDevice withLastCheckinDateTime(OffsetDateTime lastCheckinDateTime) {
        DeviceConfigurationTargetedUserAndDevice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfigurationTargetedUserAndDevice");
        _x.lastCheckinDateTime = lastCheckinDateTime;
        return _x;
    }

    /**
     * <i>“The display name of the user in the checkin”</i>
     * 
     * @return property userDisplayName
     */
    @Property(name="userDisplayName")
    @JsonIgnore
    public Optional<String> getUserDisplayName() {
        return Optional.ofNullable(userDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userDisplayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The display name of the user in the checkin”</i>
     * 
     * @param userDisplayName
     *            new value of {@code userDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userDisplayName} field changed
     */
    public DeviceConfigurationTargetedUserAndDevice withUserDisplayName(String userDisplayName) {
        DeviceConfigurationTargetedUserAndDevice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfigurationTargetedUserAndDevice");
        _x.userDisplayName = userDisplayName;
        return _x;
    }

    /**
     * <i>“The id of the user in the checkin.”</i>
     * 
     * @return property userId
     */
    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The id of the user in the checkin.”</i>
     * 
     * @param userId
     *            new value of {@code userId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userId} field changed
     */
    public DeviceConfigurationTargetedUserAndDevice withUserId(String userId) {
        DeviceConfigurationTargetedUserAndDevice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfigurationTargetedUserAndDevice");
        _x.userId = userId;
        return _x;
    }

    /**
     * <i>“The UPN of the user in the checkin.”</i>
     * 
     * @return property userPrincipalName
     */
    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userPrincipalName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The UPN of the user in the checkin.”</i>
     * 
     * @param userPrincipalName
     *            new value of {@code userPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPrincipalName} field changed
     */
    public DeviceConfigurationTargetedUserAndDevice withUserPrincipalName(String userPrincipalName) {
        DeviceConfigurationTargetedUserAndDevice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfigurationTargetedUserAndDevice");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    public DeviceConfigurationTargetedUserAndDevice withUnmappedField(String name, Object value) {
        DeviceConfigurationTargetedUserAndDevice _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String deviceId;
        private String deviceName;
        private OffsetDateTime lastCheckinDateTime;
        private String userDisplayName;
        private String userId;
        private String userPrincipalName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The id of the device in the checkin.”</i>
         * 
         * @param deviceId
         *            value of {@code deviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        /**
         * <i>“The name of the device in the checkin.”</i>
         * 
         * @param deviceName
         *            value of {@code deviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            this.changedFields = changedFields.add("deviceName");
            return this;
        }

        /**
         * <i>“Last checkin time for this user/device pair.”</i>
         * 
         * @param lastCheckinDateTime
         *            value of {@code lastCheckinDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastCheckinDateTime(OffsetDateTime lastCheckinDateTime) {
            this.lastCheckinDateTime = lastCheckinDateTime;
            this.changedFields = changedFields.add("lastCheckinDateTime");
            return this;
        }

        /**
         * <i>“The display name of the user in the checkin”</i>
         * 
         * @param userDisplayName
         *            value of {@code userDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userDisplayName(String userDisplayName) {
            this.userDisplayName = userDisplayName;
            this.changedFields = changedFields.add("userDisplayName");
            return this;
        }

        /**
         * <i>“The id of the user in the checkin.”</i>
         * 
         * @param userId
         *            value of {@code userId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        /**
         * <i>“The UPN of the user in the checkin.”</i>
         * 
         * @param userPrincipalName
         *            value of {@code userPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public DeviceConfigurationTargetedUserAndDevice build() {
            DeviceConfigurationTargetedUserAndDevice _x = new DeviceConfigurationTargetedUserAndDevice();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceConfigurationTargetedUserAndDevice";
            _x.deviceId = deviceId;
            _x.deviceName = deviceName;
            _x.lastCheckinDateTime = lastCheckinDateTime;
            _x.userDisplayName = userDisplayName;
            _x.userId = userId;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    private DeviceConfigurationTargetedUserAndDevice _copy() {
        DeviceConfigurationTargetedUserAndDevice _x = new DeviceConfigurationTargetedUserAndDevice();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.deviceId = deviceId;
        _x.deviceName = deviceName;
        _x.lastCheckinDateTime = lastCheckinDateTime;
        _x.userDisplayName = userDisplayName;
        _x.userId = userId;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceConfigurationTargetedUserAndDevice[");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("deviceName=");
        b.append(this.deviceName);
        b.append(", ");
        b.append("lastCheckinDateTime=");
        b.append(this.lastCheckinDateTime);
        b.append(", ");
        b.append("userDisplayName=");
        b.append(this.userDisplayName);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
