package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.Code;
import odata.msgraph.client.beta.enums.DeviceComplianceScriptRulesValidationError;

@JsonPropertyOrder({
    "@odata.type", 
    "settingName"})
@JsonInclude(Include.NON_NULL)
public class DeviceComplianceScriptRuleError extends DeviceComplianceScriptError implements ODataType {

    @JsonProperty("settingName")
    protected String settingName;

    protected DeviceComplianceScriptRuleError() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceComplianceScriptRuleError";
    }

    /**
     * <i>“Setting name for the rule with error.”</i>
     * 
     * @return property settingName
     */
    @Property(name="settingName")
    @JsonIgnore
    public Optional<String> getSettingName() {
        return Optional.ofNullable(settingName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settingName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Setting name for the rule with error.”</i>
     * 
     * @param settingName
     *            new value of {@code settingName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingName} field changed
     */
    public DeviceComplianceScriptRuleError withSettingName(String settingName) {
        DeviceComplianceScriptRuleError _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScriptRuleError");
        _x.settingName = settingName;
        return _x;
    }

    public DeviceComplianceScriptRuleError withUnmappedField(String name, Object value) {
        DeviceComplianceScriptRuleError _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceComplianceScriptRuleError() {
        return new Builder();
    }

    public static final class Builder {
        private Code code;
        private DeviceComplianceScriptRulesValidationError deviceComplianceScriptRulesValidationError;
        private String message;
        private String settingName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder code(Code code) {
            this.code = code;
            this.changedFields = changedFields.add("code");
            return this;
        }

        public Builder deviceComplianceScriptRulesValidationError(DeviceComplianceScriptRulesValidationError deviceComplianceScriptRulesValidationError) {
            this.deviceComplianceScriptRulesValidationError = deviceComplianceScriptRulesValidationError;
            this.changedFields = changedFields.add("deviceComplianceScriptRulesValidationError");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.changedFields = changedFields.add("message");
            return this;
        }

        /**
         * <i>“Setting name for the rule with error.”</i>
         * 
         * @param settingName
         *            value of {@code settingName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingName(String settingName) {
            this.settingName = settingName;
            this.changedFields = changedFields.add("settingName");
            return this;
        }

        public DeviceComplianceScriptRuleError build() {
            DeviceComplianceScriptRuleError _x = new DeviceComplianceScriptRuleError();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceComplianceScriptRuleError";
            _x.code = code;
            _x.deviceComplianceScriptRulesValidationError = deviceComplianceScriptRulesValidationError;
            _x.message = message;
            _x.settingName = settingName;
            return _x;
        }
    }

    private DeviceComplianceScriptRuleError _copy() {
        DeviceComplianceScriptRuleError _x = new DeviceComplianceScriptRuleError();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.code = code;
        _x.deviceComplianceScriptRulesValidationError = deviceComplianceScriptRulesValidationError;
        _x.message = message;
        _x.settingName = settingName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceComplianceScriptRuleError[");
        b.append("code=");
        b.append(this.code);
        b.append(", ");
        b.append("deviceComplianceScriptRulesValidationError=");
        b.append(this.deviceComplianceScriptRulesValidationError);
        b.append(", ");
        b.append("message=");
        b.append(this.message);
        b.append(", ");
        b.append("settingName=");
        b.append(this.settingName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
