package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DataType;
import odata.msgraph.client.beta.enums.DeviceComplianceScriptRulOperator;
import odata.msgraph.client.beta.enums.DeviceComplianceScriptRuleDataType;
import odata.msgraph.client.beta.enums.Operator;

@JsonPropertyOrder({
    "@odata.type", 
    "dataType", 
    "deviceComplianceScriptRuleDataType", 
    "deviceComplianceScriptRulOperator", 
    "operand", 
    "operator", 
    "settingName"})
@JsonInclude(Include.NON_NULL)
public class DeviceComplianceScriptRule implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("dataType")
    protected DataType dataType;

    @JsonProperty("deviceComplianceScriptRuleDataType")
    protected DeviceComplianceScriptRuleDataType deviceComplianceScriptRuleDataType;

    @JsonProperty("deviceComplianceScriptRulOperator")
    protected DeviceComplianceScriptRulOperator deviceComplianceScriptRulOperator;

    @JsonProperty("operand")
    protected String operand;

    @JsonProperty("operator")
    protected Operator operator;

    @JsonProperty("settingName")
    protected String settingName;

    protected DeviceComplianceScriptRule() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceComplianceScriptRule";
    }

    /**
     * <i>“Data type specified in the rule.”</i>
     * 
     * @return property dataType
     */
    @Property(name="dataType")
    @JsonIgnore
    public Optional<DataType> getDataType() {
        return Optional.ofNullable(dataType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code dataType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Data type specified in the rule.”</i>
     * 
     * @param dataType
     *            new value of {@code dataType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dataType} field changed
     */
    public DeviceComplianceScriptRule withDataType(DataType dataType) {
        DeviceComplianceScriptRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScriptRule");
        _x.dataType = dataType;
        return _x;
    }

    /**
     * <i>“Data type specified in the rule.”</i>
     * 
     * @return property deviceComplianceScriptRuleDataType
     */
    @Property(name="deviceComplianceScriptRuleDataType")
    @JsonIgnore
    public Optional<DeviceComplianceScriptRuleDataType> getDeviceComplianceScriptRuleDataType() {
        return Optional.ofNullable(deviceComplianceScriptRuleDataType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceComplianceScriptRuleDataType} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Data type specified in the rule.”</i>
     * 
     * @param deviceComplianceScriptRuleDataType
     *            new value of {@code deviceComplianceScriptRuleDataType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceComplianceScriptRuleDataType} field changed
     */
    public DeviceComplianceScriptRule withDeviceComplianceScriptRuleDataType(DeviceComplianceScriptRuleDataType deviceComplianceScriptRuleDataType) {
        DeviceComplianceScriptRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScriptRule");
        _x.deviceComplianceScriptRuleDataType = deviceComplianceScriptRuleDataType;
        return _x;
    }

    /**
     * <i>“Operator specified in the rule.”</i>
     * 
     * @return property deviceComplianceScriptRulOperator
     */
    @Property(name="deviceComplianceScriptRulOperator")
    @JsonIgnore
    public Optional<DeviceComplianceScriptRulOperator> getDeviceComplianceScriptRulOperator() {
        return Optional.ofNullable(deviceComplianceScriptRulOperator);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceComplianceScriptRulOperator} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Operator specified in the rule.”</i>
     * 
     * @param deviceComplianceScriptRulOperator
     *            new value of {@code deviceComplianceScriptRulOperator} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceComplianceScriptRulOperator} field changed
     */
    public DeviceComplianceScriptRule withDeviceComplianceScriptRulOperator(DeviceComplianceScriptRulOperator deviceComplianceScriptRulOperator) {
        DeviceComplianceScriptRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScriptRule");
        _x.deviceComplianceScriptRulOperator = deviceComplianceScriptRulOperator;
        return _x;
    }

    /**
     * <i>“Operand specified in the rule.”</i>
     * 
     * @return property operand
     */
    @Property(name="operand")
    @JsonIgnore
    public Optional<String> getOperand() {
        return Optional.ofNullable(operand);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code operand} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Operand specified in the rule.”</i>
     * 
     * @param operand
     *            new value of {@code operand} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operand} field changed
     */
    public DeviceComplianceScriptRule withOperand(String operand) {
        DeviceComplianceScriptRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScriptRule");
        _x.operand = operand;
        return _x;
    }

    /**
     * <i>“Operator specified in the rule.”</i>
     * 
     * @return property operator
     */
    @Property(name="operator")
    @JsonIgnore
    public Optional<Operator> getOperator() {
        return Optional.ofNullable(operator);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code operator} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Operator specified in the rule.”</i>
     * 
     * @param operator
     *            new value of {@code operator} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operator} field changed
     */
    public DeviceComplianceScriptRule withOperator(Operator operator) {
        DeviceComplianceScriptRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScriptRule");
        _x.operator = operator;
        return _x;
    }

    /**
     * <i>“Setting name specified in the rule.”</i>
     * 
     * @return property settingName
     */
    @Property(name="settingName")
    @JsonIgnore
    public Optional<String> getSettingName() {
        return Optional.ofNullable(settingName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settingName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Setting name specified in the rule.”</i>
     * 
     * @param settingName
     *            new value of {@code settingName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingName} field changed
     */
    public DeviceComplianceScriptRule withSettingName(String settingName) {
        DeviceComplianceScriptRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScriptRule");
        _x.settingName = settingName;
        return _x;
    }

    public DeviceComplianceScriptRule withUnmappedField(String name, Object value) {
        DeviceComplianceScriptRule _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DataType dataType;
        private DeviceComplianceScriptRuleDataType deviceComplianceScriptRuleDataType;
        private DeviceComplianceScriptRulOperator deviceComplianceScriptRulOperator;
        private String operand;
        private Operator operator;
        private String settingName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Data type specified in the rule.”</i>
         * 
         * @param dataType
         *            value of {@code dataType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dataType(DataType dataType) {
            this.dataType = dataType;
            this.changedFields = changedFields.add("dataType");
            return this;
        }

        /**
         * <i>“Data type specified in the rule.”</i>
         * 
         * @param deviceComplianceScriptRuleDataType
         *            value of {@code deviceComplianceScriptRuleDataType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceComplianceScriptRuleDataType(DeviceComplianceScriptRuleDataType deviceComplianceScriptRuleDataType) {
            this.deviceComplianceScriptRuleDataType = deviceComplianceScriptRuleDataType;
            this.changedFields = changedFields.add("deviceComplianceScriptRuleDataType");
            return this;
        }

        /**
         * <i>“Operator specified in the rule.”</i>
         * 
         * @param deviceComplianceScriptRulOperator
         *            value of {@code deviceComplianceScriptRulOperator} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceComplianceScriptRulOperator(DeviceComplianceScriptRulOperator deviceComplianceScriptRulOperator) {
            this.deviceComplianceScriptRulOperator = deviceComplianceScriptRulOperator;
            this.changedFields = changedFields.add("deviceComplianceScriptRulOperator");
            return this;
        }

        /**
         * <i>“Operand specified in the rule.”</i>
         * 
         * @param operand
         *            value of {@code operand} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operand(String operand) {
            this.operand = operand;
            this.changedFields = changedFields.add("operand");
            return this;
        }

        /**
         * <i>“Operator specified in the rule.”</i>
         * 
         * @param operator
         *            value of {@code operator} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operator(Operator operator) {
            this.operator = operator;
            this.changedFields = changedFields.add("operator");
            return this;
        }

        /**
         * <i>“Setting name specified in the rule.”</i>
         * 
         * @param settingName
         *            value of {@code settingName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingName(String settingName) {
            this.settingName = settingName;
            this.changedFields = changedFields.add("settingName");
            return this;
        }

        public DeviceComplianceScriptRule build() {
            DeviceComplianceScriptRule _x = new DeviceComplianceScriptRule();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceComplianceScriptRule";
            _x.dataType = dataType;
            _x.deviceComplianceScriptRuleDataType = deviceComplianceScriptRuleDataType;
            _x.deviceComplianceScriptRulOperator = deviceComplianceScriptRulOperator;
            _x.operand = operand;
            _x.operator = operator;
            _x.settingName = settingName;
            return _x;
        }
    }

    private DeviceComplianceScriptRule _copy() {
        DeviceComplianceScriptRule _x = new DeviceComplianceScriptRule();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.dataType = dataType;
        _x.deviceComplianceScriptRuleDataType = deviceComplianceScriptRuleDataType;
        _x.deviceComplianceScriptRulOperator = deviceComplianceScriptRulOperator;
        _x.operand = operand;
        _x.operator = operator;
        _x.settingName = settingName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceComplianceScriptRule[");
        b.append("dataType=");
        b.append(this.dataType);
        b.append(", ");
        b.append("deviceComplianceScriptRuleDataType=");
        b.append(this.deviceComplianceScriptRuleDataType);
        b.append(", ");
        b.append("deviceComplianceScriptRulOperator=");
        b.append(this.deviceComplianceScriptRulOperator);
        b.append(", ");
        b.append("operand=");
        b.append(this.operand);
        b.append(", ");
        b.append("operator=");
        b.append(this.operator);
        b.append(", ");
        b.append("settingName=");
        b.append(this.settingName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
