package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.Code;
import odata.msgraph.client.beta.enums.DeviceComplianceScriptRulesValidationError;

@JsonPropertyOrder({
    "@odata.type", 
    "code", 
    "deviceComplianceScriptRulesValidationError", 
    "message"})
@JsonInclude(Include.NON_NULL)
public class DeviceComplianceScriptError implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("code")
    protected Code code;

    @JsonProperty("deviceComplianceScriptRulesValidationError")
    protected DeviceComplianceScriptRulesValidationError deviceComplianceScriptRulesValidationError;

    @JsonProperty("message")
    protected String message;

    protected DeviceComplianceScriptError() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceComplianceScriptError";
    }

    /**
     * <i>“Error code.”</i>
     * 
     * @return property code
     */
    @Property(name="code")
    @JsonIgnore
    public Optional<Code> getCode() {
        return Optional.ofNullable(code);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code code} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Error code.”</i>
     * 
     * @param code
     *            new value of {@code code} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code code} field changed
     */
    public DeviceComplianceScriptError withCode(Code code) {
        DeviceComplianceScriptError _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScriptError");
        _x.code = code;
        return _x;
    }

    /**
     * <i>“Error code.”</i>
     * 
     * @return property deviceComplianceScriptRulesValidationError
     */
    @Property(name="deviceComplianceScriptRulesValidationError")
    @JsonIgnore
    public Optional<DeviceComplianceScriptRulesValidationError> getDeviceComplianceScriptRulesValidationError() {
        return Optional.ofNullable(deviceComplianceScriptRulesValidationError);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceComplianceScriptRulesValidationError} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Error code.”</i>
     * 
     * @param deviceComplianceScriptRulesValidationError
     *            new value of {@code deviceComplianceScriptRulesValidationError} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceComplianceScriptRulesValidationError} field changed
     */
    public DeviceComplianceScriptError withDeviceComplianceScriptRulesValidationError(DeviceComplianceScriptRulesValidationError deviceComplianceScriptRulesValidationError) {
        DeviceComplianceScriptError _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScriptError");
        _x.deviceComplianceScriptRulesValidationError = deviceComplianceScriptRulesValidationError;
        return _x;
    }

    /**
     * <i>“Error message.”</i>
     * 
     * @return property message
     */
    @Property(name="message")
    @JsonIgnore
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code message} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Error message.”</i>
     * 
     * @param message
     *            new value of {@code message} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code message} field changed
     */
    public DeviceComplianceScriptError withMessage(String message) {
        DeviceComplianceScriptError _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScriptError");
        _x.message = message;
        return _x;
    }

    public DeviceComplianceScriptError withUnmappedField(String name, Object value) {
        DeviceComplianceScriptError _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Code code;
        private DeviceComplianceScriptRulesValidationError deviceComplianceScriptRulesValidationError;
        private String message;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Error code.”</i>
         * 
         * @param code
         *            value of {@code code} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder code(Code code) {
            this.code = code;
            this.changedFields = changedFields.add("code");
            return this;
        }

        /**
         * <i>“Error code.”</i>
         * 
         * @param deviceComplianceScriptRulesValidationError
         *            value of {@code deviceComplianceScriptRulesValidationError} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceComplianceScriptRulesValidationError(DeviceComplianceScriptRulesValidationError deviceComplianceScriptRulesValidationError) {
            this.deviceComplianceScriptRulesValidationError = deviceComplianceScriptRulesValidationError;
            this.changedFields = changedFields.add("deviceComplianceScriptRulesValidationError");
            return this;
        }

        /**
         * <i>“Error message.”</i>
         * 
         * @param message
         *            value of {@code message} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder message(String message) {
            this.message = message;
            this.changedFields = changedFields.add("message");
            return this;
        }

        public DeviceComplianceScriptError build() {
            DeviceComplianceScriptError _x = new DeviceComplianceScriptError();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceComplianceScriptError";
            _x.code = code;
            _x.deviceComplianceScriptRulesValidationError = deviceComplianceScriptRulesValidationError;
            _x.message = message;
            return _x;
        }
    }

    private DeviceComplianceScriptError _copy() {
        DeviceComplianceScriptError _x = new DeviceComplianceScriptError();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.code = code;
        _x.deviceComplianceScriptRulesValidationError = deviceComplianceScriptRulesValidationError;
        _x.message = message;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceComplianceScriptError[");
        b.append("code=");
        b.append(this.code);
        b.append(", ");
        b.append("deviceComplianceScriptRulesValidationError=");
        b.append(this.deviceComplianceScriptRulesValidationError);
        b.append(", ");
        b.append("message=");
        b.append(this.message);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
