package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“The set of Role Definitions and Role Assignments assigned to a user.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "roleAssignmentIds", 
    "roleDefinitionIds"})
@JsonInclude(Include.NON_NULL)
public class DeviceAndAppManagementAssignedRoleDetails implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("roleAssignmentIds")
    protected List<String> roleAssignmentIds;

    @JsonProperty("roleAssignmentIds@nextLink")
    protected String roleAssignmentIdsNextLink;

    @JsonProperty("roleDefinitionIds")
    protected List<String> roleDefinitionIds;

    @JsonProperty("roleDefinitionIds@nextLink")
    protected String roleDefinitionIdsNextLink;

    protected DeviceAndAppManagementAssignedRoleDetails() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceAndAppManagementAssignedRoleDetails";
    }

    /**
     * <i>“Role Assignment IDs for the specifc Role Assignments assigned to a user. This
     * property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property roleAssignmentIds
     */
    @Property(name="roleAssignmentIds")
    @JsonIgnore
    public CollectionPage<String> getRoleAssignmentIds() {
        return new CollectionPage<String>(contextPath, String.class, this.roleAssignmentIds, Optional.ofNullable(roleAssignmentIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Role Assignment IDs for the specifc Role Assignments assigned to a user. This
     * property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property roleAssignmentIds
     */
    @Property(name="roleAssignmentIds")
    @JsonIgnore
    public CollectionPage<String> getRoleAssignmentIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.roleAssignmentIds, Optional.ofNullable(roleAssignmentIdsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Role Definition IDs for the specifc Role Definitions assigned to a user. This
     * property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property roleDefinitionIds
     */
    @Property(name="roleDefinitionIds")
    @JsonIgnore
    public CollectionPage<String> getRoleDefinitionIds() {
        return new CollectionPage<String>(contextPath, String.class, this.roleDefinitionIds, Optional.ofNullable(roleDefinitionIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Role Definition IDs for the specifc Role Definitions assigned to a user. This
     * property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property roleDefinitionIds
     */
    @Property(name="roleDefinitionIds")
    @JsonIgnore
    public CollectionPage<String> getRoleDefinitionIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.roleDefinitionIds, Optional.ofNullable(roleDefinitionIdsNextLink), Collections.emptyList(), options);
    }

    public DeviceAndAppManagementAssignedRoleDetails withUnmappedField(String name, Object value) {
        DeviceAndAppManagementAssignedRoleDetails _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> roleAssignmentIds;
        private String roleAssignmentIdsNextLink;
        private List<String> roleDefinitionIds;
        private String roleDefinitionIdsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Role Assignment IDs for the specifc Role Assignments assigned to a user. This
         * property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param roleAssignmentIds
         *            value of {@code roleAssignmentIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleAssignmentIds(List<String> roleAssignmentIds) {
            this.roleAssignmentIds = roleAssignmentIds;
            this.changedFields = changedFields.add("roleAssignmentIds");
            return this;
        }

        /**
         * <i>“Role Assignment IDs for the specifc Role Assignments assigned to a user. This
         * property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param roleAssignmentIds
         *            value of {@code roleAssignmentIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleAssignmentIds(String... roleAssignmentIds) {
            return roleAssignmentIds(Arrays.asList(roleAssignmentIds));
        }

        /**
         * <i>“Role Assignment IDs for the specifc Role Assignments assigned to a user. This
         * property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param roleAssignmentIdsNextLink
         *            value of {@code roleAssignmentIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleAssignmentIdsNextLink(String roleAssignmentIdsNextLink) {
            this.roleAssignmentIdsNextLink = roleAssignmentIdsNextLink;
            this.changedFields = changedFields.add("roleAssignmentIds");
            return this;
        }

        /**
         * <i>“Role Definition IDs for the specifc Role Definitions assigned to a user. This
         * property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param roleDefinitionIds
         *            value of {@code roleDefinitionIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleDefinitionIds(List<String> roleDefinitionIds) {
            this.roleDefinitionIds = roleDefinitionIds;
            this.changedFields = changedFields.add("roleDefinitionIds");
            return this;
        }

        /**
         * <i>“Role Definition IDs for the specifc Role Definitions assigned to a user. This
         * property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param roleDefinitionIds
         *            value of {@code roleDefinitionIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleDefinitionIds(String... roleDefinitionIds) {
            return roleDefinitionIds(Arrays.asList(roleDefinitionIds));
        }

        /**
         * <i>“Role Definition IDs for the specifc Role Definitions assigned to a user. This
         * property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param roleDefinitionIdsNextLink
         *            value of {@code roleDefinitionIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleDefinitionIdsNextLink(String roleDefinitionIdsNextLink) {
            this.roleDefinitionIdsNextLink = roleDefinitionIdsNextLink;
            this.changedFields = changedFields.add("roleDefinitionIds");
            return this;
        }

        public DeviceAndAppManagementAssignedRoleDetails build() {
            DeviceAndAppManagementAssignedRoleDetails _x = new DeviceAndAppManagementAssignedRoleDetails();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceAndAppManagementAssignedRoleDetails";
            _x.roleAssignmentIds = roleAssignmentIds;
            _x.roleAssignmentIdsNextLink = roleAssignmentIdsNextLink;
            _x.roleDefinitionIds = roleDefinitionIds;
            _x.roleDefinitionIdsNextLink = roleDefinitionIdsNextLink;
            return _x;
        }
    }

    private DeviceAndAppManagementAssignedRoleDetails _copy() {
        DeviceAndAppManagementAssignedRoleDetails _x = new DeviceAndAppManagementAssignedRoleDetails();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.roleAssignmentIds = roleAssignmentIds;
        _x.roleDefinitionIds = roleDefinitionIds;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceAndAppManagementAssignedRoleDetails[");
        b.append("roleAssignmentIds=");
        b.append(this.roleAssignmentIds);
        b.append(", ");
        b.append("roleDefinitionIds=");
        b.append(this.roleDefinitionIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
