package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.enums.ClassificationMethod;
import odata.msgraph.client.beta.enums.SensitiveTypeScope;
import odata.msgraph.client.beta.enums.SensitiveTypeSource;

@JsonPropertyOrder({
    "@odata.type", 
    "classificationAttributes", 
    "classificationMethod", 
    "matches", 
    "scope", 
    "sensitiveTypeSource"})
@JsonInclude(Include.NON_NULL)
public class DetectedSensitiveContent extends DetectedSensitiveContentBase implements ODataType {

    @JsonProperty("classificationAttributes")
    protected List<ClassificationAttribute> classificationAttributes;

    @JsonProperty("classificationAttributes@nextLink")
    protected String classificationAttributesNextLink;

    @JsonProperty("classificationMethod")
    protected ClassificationMethod classificationMethod;

    @JsonProperty("matches")
    protected List<SensitiveContentLocation> matches;

    @JsonProperty("matches@nextLink")
    protected String matchesNextLink;

    @JsonProperty("scope")
    protected SensitiveTypeScope scope;

    @JsonProperty("sensitiveTypeSource")
    protected SensitiveTypeSource sensitiveTypeSource;

    protected DetectedSensitiveContent() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.detectedSensitiveContent";
    }

    @Property(name="classificationAttributes")
    @JsonIgnore
    public CollectionPage<ClassificationAttribute> getClassificationAttributes() {
        return new CollectionPage<ClassificationAttribute>(contextPath, ClassificationAttribute.class, this.classificationAttributes, Optional.ofNullable(classificationAttributesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="classificationAttributes")
    @JsonIgnore
    public CollectionPage<ClassificationAttribute> getClassificationAttributes(HttpRequestOptions options) {
        return new CollectionPage<ClassificationAttribute>(contextPath, ClassificationAttribute.class, this.classificationAttributes, Optional.ofNullable(classificationAttributesNextLink), Collections.emptyList(), options);
    }

    @Property(name="classificationMethod")
    @JsonIgnore
    public Optional<ClassificationMethod> getClassificationMethod() {
        return Optional.ofNullable(classificationMethod);
    }

    public DetectedSensitiveContent withClassificationMethod(ClassificationMethod classificationMethod) {
        DetectedSensitiveContent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.detectedSensitiveContent");
        _x.classificationMethod = classificationMethod;
        return _x;
    }

    @Property(name="matches")
    @JsonIgnore
    public CollectionPage<SensitiveContentLocation> getMatches() {
        return new CollectionPage<SensitiveContentLocation>(contextPath, SensitiveContentLocation.class, this.matches, Optional.ofNullable(matchesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="matches")
    @JsonIgnore
    public CollectionPage<SensitiveContentLocation> getMatches(HttpRequestOptions options) {
        return new CollectionPage<SensitiveContentLocation>(contextPath, SensitiveContentLocation.class, this.matches, Optional.ofNullable(matchesNextLink), Collections.emptyList(), options);
    }

    @Property(name="scope")
    @JsonIgnore
    public Optional<SensitiveTypeScope> getScope() {
        return Optional.ofNullable(scope);
    }

    public DetectedSensitiveContent withScope(SensitiveTypeScope scope) {
        DetectedSensitiveContent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.detectedSensitiveContent");
        _x.scope = scope;
        return _x;
    }

    @Property(name="sensitiveTypeSource")
    @JsonIgnore
    public Optional<SensitiveTypeSource> getSensitiveTypeSource() {
        return Optional.ofNullable(sensitiveTypeSource);
    }

    public DetectedSensitiveContent withSensitiveTypeSource(SensitiveTypeSource sensitiveTypeSource) {
        DetectedSensitiveContent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.detectedSensitiveContent");
        _x.sensitiveTypeSource = sensitiveTypeSource;
        return _x;
    }

    public DetectedSensitiveContent withUnmappedField(String name, Object value) {
        DetectedSensitiveContent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDetectedSensitiveContent() {
        return new Builder();
    }

    public static final class Builder {
        private Integer confidence;
        private String displayName;
        private UUID id;
        private Integer recommendedConfidence;
        private Integer uniqueCount;
        private List<ClassificationAttribute> classificationAttributes;
        private String classificationAttributesNextLink;
        private ClassificationMethod classificationMethod;
        private List<SensitiveContentLocation> matches;
        private String matchesNextLink;
        private SensitiveTypeScope scope;
        private SensitiveTypeSource sensitiveTypeSource;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder confidence(Integer confidence) {
            this.confidence = confidence;
            this.changedFields = changedFields.add("confidence");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder id(UUID id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder recommendedConfidence(Integer recommendedConfidence) {
            this.recommendedConfidence = recommendedConfidence;
            this.changedFields = changedFields.add("recommendedConfidence");
            return this;
        }

        public Builder uniqueCount(Integer uniqueCount) {
            this.uniqueCount = uniqueCount;
            this.changedFields = changedFields.add("uniqueCount");
            return this;
        }

        public Builder classificationAttributes(List<ClassificationAttribute> classificationAttributes) {
            this.classificationAttributes = classificationAttributes;
            this.changedFields = changedFields.add("classificationAttributes");
            return this;
        }

        public Builder classificationAttributes(ClassificationAttribute... classificationAttributes) {
            return classificationAttributes(Arrays.asList(classificationAttributes));
        }

        public Builder classificationAttributesNextLink(String classificationAttributesNextLink) {
            this.classificationAttributesNextLink = classificationAttributesNextLink;
            this.changedFields = changedFields.add("classificationAttributes");
            return this;
        }

        public Builder classificationMethod(ClassificationMethod classificationMethod) {
            this.classificationMethod = classificationMethod;
            this.changedFields = changedFields.add("classificationMethod");
            return this;
        }

        public Builder matches(List<SensitiveContentLocation> matches) {
            this.matches = matches;
            this.changedFields = changedFields.add("matches");
            return this;
        }

        public Builder matches(SensitiveContentLocation... matches) {
            return matches(Arrays.asList(matches));
        }

        public Builder matchesNextLink(String matchesNextLink) {
            this.matchesNextLink = matchesNextLink;
            this.changedFields = changedFields.add("matches");
            return this;
        }

        public Builder scope(SensitiveTypeScope scope) {
            this.scope = scope;
            this.changedFields = changedFields.add("scope");
            return this;
        }

        public Builder sensitiveTypeSource(SensitiveTypeSource sensitiveTypeSource) {
            this.sensitiveTypeSource = sensitiveTypeSource;
            this.changedFields = changedFields.add("sensitiveTypeSource");
            return this;
        }

        public DetectedSensitiveContent build() {
            DetectedSensitiveContent _x = new DetectedSensitiveContent();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.detectedSensitiveContent";
            _x.confidence = confidence;
            _x.displayName = displayName;
            _x.id = id;
            _x.recommendedConfidence = recommendedConfidence;
            _x.uniqueCount = uniqueCount;
            _x.classificationAttributes = classificationAttributes;
            _x.classificationAttributesNextLink = classificationAttributesNextLink;
            _x.classificationMethod = classificationMethod;
            _x.matches = matches;
            _x.matchesNextLink = matchesNextLink;
            _x.scope = scope;
            _x.sensitiveTypeSource = sensitiveTypeSource;
            return _x;
        }
    }

    private DetectedSensitiveContent _copy() {
        DetectedSensitiveContent _x = new DetectedSensitiveContent();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.confidence = confidence;
        _x.displayName = displayName;
        _x.id = id;
        _x.recommendedConfidence = recommendedConfidence;
        _x.uniqueCount = uniqueCount;
        _x.classificationAttributes = classificationAttributes;
        _x.classificationMethod = classificationMethod;
        _x.matches = matches;
        _x.scope = scope;
        _x.sensitiveTypeSource = sensitiveTypeSource;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DetectedSensitiveContent[");
        b.append("confidence=");
        b.append(this.confidence);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("recommendedConfidence=");
        b.append(this.recommendedConfidence);
        b.append(", ");
        b.append("uniqueCount=");
        b.append(this.uniqueCount);
        b.append(", ");
        b.append("classificationAttributes=");
        b.append(this.classificationAttributes);
        b.append(", ");
        b.append("classificationMethod=");
        b.append(this.classificationMethod);
        b.append(", ");
        b.append("matches=");
        b.append(this.matches);
        b.append(", ");
        b.append("scope=");
        b.append(this.scope);
        b.append(", ");
        b.append("sensitiveTypeSource=");
        b.append(this.sensitiveTypeSource);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
